/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Country;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class GeoShapeImpl
extends StructuredValueImpl
implements GeoShape {
    private static final ImmutableSet<String> PROPERTY_SET = GeoShapeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/address");
        builder.add((Object)"http://schema.org/addressCountry");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/box");
        builder.add((Object)"http://schema.org/circle");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/elevation");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/line");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/polygon");
        builder.add((Object)"http://schema.org/postalCode");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public GeoShapeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/GeoShape";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressList() {
        return this.getProperty("http://schema.org/address");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressCountryList() {
        return this.getProperty("http://schema.org/addressCountry");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBoxList() {
        return this.getProperty("http://schema.org/box");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCircleList() {
        return this.getProperty("http://schema.org/circle");
    }

    @Override
    public ImmutableList<SchemaOrgType> getElevationList() {
        return this.getProperty("http://schema.org/elevation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLineList() {
        return this.getProperty("http://schema.org/line");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPolygonList() {
        return this.getProperty("http://schema.org/polygon");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPostalCodeList() {
        return this.getProperty("http://schema.org/postalCode");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<GeoShape.Builder>
    implements GeoShape.Builder {
        BuilderImpl() {
        }

        @Override
        public GeoShape.Builder addAdditionalType(URL value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public GeoShape.Builder addAdditionalType(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public GeoShape.Builder addAddress(PostalAddress value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/address", value);
        }

        @Override
        public GeoShape.Builder addAddress(PostalAddress.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/address", value.build());
        }

        @Override
        public GeoShape.Builder addAddress(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/address", value);
        }

        @Override
        public GeoShape.Builder addAddress(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/address", Text.of(value));
        }

        @Override
        public GeoShape.Builder addAddressCountry(Country value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/addressCountry", value);
        }

        @Override
        public GeoShape.Builder addAddressCountry(Country.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/addressCountry", value.build());
        }

        @Override
        public GeoShape.Builder addAddressCountry(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/addressCountry", value);
        }

        @Override
        public GeoShape.Builder addAddressCountry(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/addressCountry", Text.of(value));
        }

        @Override
        public GeoShape.Builder addAlternateName(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public GeoShape.Builder addAlternateName(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public GeoShape.Builder addBox(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/box", value);
        }

        @Override
        public GeoShape.Builder addBox(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/box", Text.of(value));
        }

        @Override
        public GeoShape.Builder addCircle(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/circle", value);
        }

        @Override
        public GeoShape.Builder addCircle(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/circle", Text.of(value));
        }

        @Override
        public GeoShape.Builder addDescription(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public GeoShape.Builder addDescription(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public GeoShape.Builder addElevation(Number value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/elevation", value);
        }

        @Override
        public GeoShape.Builder addElevation(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/elevation", value);
        }

        @Override
        public GeoShape.Builder addElevation(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/elevation", Text.of(value));
        }

        @Override
        public GeoShape.Builder addImage(ImageObject value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public GeoShape.Builder addImage(ImageObject.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public GeoShape.Builder addImage(URL value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public GeoShape.Builder addImage(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public GeoShape.Builder addLine(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/line", value);
        }

        @Override
        public GeoShape.Builder addLine(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/line", Text.of(value));
        }

        @Override
        public GeoShape.Builder addMainEntityOfPage(CreativeWork value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public GeoShape.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public GeoShape.Builder addMainEntityOfPage(URL value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public GeoShape.Builder addMainEntityOfPage(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public GeoShape.Builder addName(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public GeoShape.Builder addName(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public GeoShape.Builder addPolygon(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/polygon", value);
        }

        @Override
        public GeoShape.Builder addPolygon(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/polygon", Text.of(value));
        }

        @Override
        public GeoShape.Builder addPostalCode(Text value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/postalCode", value);
        }

        @Override
        public GeoShape.Builder addPostalCode(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/postalCode", Text.of(value));
        }

        @Override
        public GeoShape.Builder addPotentialAction(Action value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public GeoShape.Builder addPotentialAction(Action.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public GeoShape.Builder addPotentialAction(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public GeoShape.Builder addSameAs(URL value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public GeoShape.Builder addSameAs(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public GeoShape.Builder addUrl(URL value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public GeoShape.Builder addUrl(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public GeoShape.Builder addDetailedDescription(Article value) {
            return (GeoShape.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public GeoShape.Builder addDetailedDescription(Article.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public GeoShape.Builder addDetailedDescription(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public GeoShape.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (GeoShape.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public GeoShape.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (GeoShape.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public GeoShape.Builder addPopularityScore(String value) {
            return (GeoShape.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public GeoShape build() {
            return new GeoShapeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

