/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.ItemList;
import com.google.schemaorg.core.ItemListOrderType;
import com.google.schemaorg.core.ListItem;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ItemListImpl
extends IntangibleImpl
implements ItemList {
    private static final ImmutableSet<String> PROPERTY_SET = ItemListImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/itemListElement");
        builder.add((Object)"http://schema.org/itemListOrder");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numberOfItems");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ItemListImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/ItemList";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemListElementList() {
        return this.getProperty("http://schema.org/itemListElement");
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemListOrderList() {
        return this.getProperty("http://schema.org/itemListOrder");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNumberOfItemsList() {
        return this.getProperty("http://schema.org/numberOfItems");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<ItemList.Builder>
    implements ItemList.Builder {
        BuilderImpl() {
        }

        @Override
        public ItemList.Builder addAdditionalType(URL value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public ItemList.Builder addAdditionalType(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public ItemList.Builder addAlternateName(Text value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public ItemList.Builder addAlternateName(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public ItemList.Builder addDescription(Text value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public ItemList.Builder addDescription(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public ItemList.Builder addImage(ImageObject value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ItemList.Builder addImage(ImageObject.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public ItemList.Builder addImage(URL value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ItemList.Builder addImage(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public ItemList.Builder addItemListElement(ListItem value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public ItemList.Builder addItemListElement(ListItem.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListElement", value.build());
        }

        @Override
        public ItemList.Builder addItemListElement(Text value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public ItemList.Builder addItemListElement(Thing value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListElement", value);
        }

        @Override
        public ItemList.Builder addItemListElement(Thing.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListElement", value.build());
        }

        @Override
        public ItemList.Builder addItemListElement(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListElement", Text.of(value));
        }

        @Override
        public ItemList.Builder addItemListOrder(ItemListOrderType value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListOrder", value);
        }

        @Override
        public ItemList.Builder addItemListOrder(Text value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListOrder", value);
        }

        @Override
        public ItemList.Builder addItemListOrder(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/itemListOrder", Text.of(value));
        }

        @Override
        public ItemList.Builder addMainEntityOfPage(CreativeWork value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ItemList.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public ItemList.Builder addMainEntityOfPage(URL value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ItemList.Builder addMainEntityOfPage(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public ItemList.Builder addName(Text value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public ItemList.Builder addName(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public ItemList.Builder addNumberOfItems(Integer value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/numberOfItems", value);
        }

        @Override
        public ItemList.Builder addNumberOfItems(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/numberOfItems", Text.of(value));
        }

        @Override
        public ItemList.Builder addPotentialAction(Action value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public ItemList.Builder addPotentialAction(Action.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public ItemList.Builder addPotentialAction(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public ItemList.Builder addSameAs(URL value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public ItemList.Builder addSameAs(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public ItemList.Builder addUrl(URL value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public ItemList.Builder addUrl(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public ItemList.Builder addDetailedDescription(Article value) {
            return (ItemList.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public ItemList.Builder addDetailedDescription(Article.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public ItemList.Builder addDetailedDescription(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public ItemList.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (ItemList.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public ItemList.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (ItemList.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public ItemList.Builder addPopularityScore(String value) {
            return (ItemList.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public ItemList build() {
            return new ItemListImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

