/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTest;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalTestImpl
extends MedicalEntityImpl
implements MedicalTest {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalTestImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/affectedBy");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/normalRange");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/signDetected");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/usedToDiagnose");
        builder.add((Object)"http://schema.org/usesDevice");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalTestImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalTest";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAffectedByList() {
        return this.getProperty("http://schema.org/affectedBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNormalRangeList() {
        return this.getProperty("http://schema.org/normalRange");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSignDetectedList() {
        return this.getProperty("http://schema.org/signDetected");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUsedToDiagnoseList() {
        return this.getProperty("http://schema.org/usedToDiagnose");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUsesDeviceList() {
        return this.getProperty("http://schema.org/usesDevice");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalTest.Builder>
    implements MedicalTest.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalTest.Builder addAdditionalType(URL value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalTest.Builder addAdditionalType(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addAffectedBy(Drug value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/affectedBy", value);
        }

        @Override
        public MedicalTest.Builder addAffectedBy(Drug.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/affectedBy", value.build());
        }

        @Override
        public MedicalTest.Builder addAffectedBy(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/affectedBy", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addAlternateName(Text value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalTest.Builder addAlternateName(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addCode(MedicalCode value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalTest.Builder addCode(MedicalCode.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalTest.Builder addCode(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addDescription(Text value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalTest.Builder addDescription(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addGuideline(MedicalGuideline value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalTest.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalTest.Builder addGuideline(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addImage(ImageObject value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalTest.Builder addImage(ImageObject.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalTest.Builder addImage(URL value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalTest.Builder addImage(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalTest.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalTest.Builder addMainEntityOfPage(URL value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalTest.Builder addMainEntityOfPage(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalTest.Builder addMedicineSystem(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addName(Text value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalTest.Builder addName(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addNormalRange(Text value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/normalRange", value);
        }

        @Override
        public MedicalTest.Builder addNormalRange(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/normalRange", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addPotentialAction(Action value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalTest.Builder addPotentialAction(Action.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalTest.Builder addPotentialAction(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addRecognizingAuthority(Organization value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalTest.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalTest.Builder addRecognizingAuthority(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalTest.Builder addRelevantSpecialty(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addSameAs(URL value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalTest.Builder addSameAs(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addSignDetected(MedicalSign value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/signDetected", value);
        }

        @Override
        public MedicalTest.Builder addSignDetected(MedicalSign.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/signDetected", value.build());
        }

        @Override
        public MedicalTest.Builder addSignDetected(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/signDetected", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addStudy(MedicalStudy value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalTest.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalTest.Builder addStudy(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addUrl(URL value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalTest.Builder addUrl(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addUsedToDiagnose(MedicalCondition value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value);
        }

        @Override
        public MedicalTest.Builder addUsedToDiagnose(MedicalCondition.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value.build());
        }

        @Override
        public MedicalTest.Builder addUsedToDiagnose(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addUsesDevice(MedicalDevice value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/usesDevice", value);
        }

        @Override
        public MedicalTest.Builder addUsesDevice(MedicalDevice.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/usesDevice", value.build());
        }

        @Override
        public MedicalTest.Builder addUsesDevice(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.org/usesDevice", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addDetailedDescription(Article value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalTest.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalTest.Builder addDetailedDescription(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalTest.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalTest.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalTest.Builder addPopularityScore(String value) {
            return (MedicalTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalTest build() {
            return new MedicalTestImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

