/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.OrderItem;
import com.google.schemaorg.core.OrderStatus;
import com.google.schemaorg.core.ParcelDelivery;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class OrderItemImpl
extends IntangibleImpl
implements OrderItem {
    private static final ImmutableSet<String> PROPERTY_SET = OrderItemImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/orderDelivery");
        builder.add((Object)"http://schema.org/orderedItem");
        builder.add((Object)"http://schema.org/orderItemNumber");
        builder.add((Object)"http://schema.org/orderItemStatus");
        builder.add((Object)"http://schema.org/orderQuantity");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public OrderItemImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/OrderItem";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderDeliveryList() {
        return this.getProperty("http://schema.org/orderDelivery");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderedItemList() {
        return this.getProperty("http://schema.org/orderedItem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderItemNumberList() {
        return this.getProperty("http://schema.org/orderItemNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderItemStatusList() {
        return this.getProperty("http://schema.org/orderItemStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOrderQuantityList() {
        return this.getProperty("http://schema.org/orderQuantity");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<OrderItem.Builder>
    implements OrderItem.Builder {
        BuilderImpl() {
        }

        @Override
        public OrderItem.Builder addAdditionalType(URL value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public OrderItem.Builder addAdditionalType(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public OrderItem.Builder addAlternateName(Text value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public OrderItem.Builder addAlternateName(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public OrderItem.Builder addDescription(Text value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public OrderItem.Builder addDescription(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public OrderItem.Builder addImage(ImageObject value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public OrderItem.Builder addImage(ImageObject.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public OrderItem.Builder addImage(URL value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public OrderItem.Builder addImage(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public OrderItem.Builder addMainEntityOfPage(CreativeWork value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public OrderItem.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public OrderItem.Builder addMainEntityOfPage(URL value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public OrderItem.Builder addMainEntityOfPage(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public OrderItem.Builder addName(Text value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public OrderItem.Builder addName(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public OrderItem.Builder addOrderDelivery(ParcelDelivery value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderDelivery", value);
        }

        @Override
        public OrderItem.Builder addOrderDelivery(ParcelDelivery.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderDelivery", value.build());
        }

        @Override
        public OrderItem.Builder addOrderDelivery(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderDelivery", Text.of(value));
        }

        @Override
        public OrderItem.Builder addOrderedItem(OrderItem value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderedItem", value);
        }

        @Override
        public OrderItem.Builder addOrderedItem(OrderItem.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderedItem", value.build());
        }

        @Override
        public OrderItem.Builder addOrderedItem(Product value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderedItem", value);
        }

        @Override
        public OrderItem.Builder addOrderedItem(Product.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderedItem", value.build());
        }

        @Override
        public OrderItem.Builder addOrderedItem(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderedItem", Text.of(value));
        }

        @Override
        public OrderItem.Builder addOrderItemNumber(Text value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderItemNumber", value);
        }

        @Override
        public OrderItem.Builder addOrderItemNumber(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderItemNumber", Text.of(value));
        }

        @Override
        public OrderItem.Builder addOrderItemStatus(OrderStatus value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderItemStatus", value);
        }

        @Override
        public OrderItem.Builder addOrderItemStatus(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderItemStatus", Text.of(value));
        }

        @Override
        public OrderItem.Builder addOrderQuantity(Number value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderQuantity", value);
        }

        @Override
        public OrderItem.Builder addOrderQuantity(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/orderQuantity", Text.of(value));
        }

        @Override
        public OrderItem.Builder addPotentialAction(Action value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public OrderItem.Builder addPotentialAction(Action.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public OrderItem.Builder addPotentialAction(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public OrderItem.Builder addSameAs(URL value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public OrderItem.Builder addSameAs(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public OrderItem.Builder addUrl(URL value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public OrderItem.Builder addUrl(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public OrderItem.Builder addDetailedDescription(Article value) {
            return (OrderItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public OrderItem.Builder addDetailedDescription(Article.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public OrderItem.Builder addDetailedDescription(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public OrderItem.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (OrderItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public OrderItem.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (OrderItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public OrderItem.Builder addPopularityScore(String value) {
            return (OrderItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public OrderItem build() {
            return new OrderItemImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

