/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.ProgramMembership;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ProgramMembershipImpl
extends IntangibleImpl
implements ProgramMembership {
    private static final ImmutableSet<String> PROPERTY_SET = ProgramMembershipImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/hostingOrganization");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/member");
        builder.add((Object)"http://schema.org/members");
        builder.add((Object)"http://schema.org/membershipNumber");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/programName");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ProgramMembershipImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/ProgramMembership";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getHostingOrganizationList() {
        return this.getProperty("http://schema.org/hostingOrganization");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMemberList() {
        return this.getProperty("http://schema.org/member");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMembersList() {
        return this.getProperty("http://schema.org/members");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMembershipNumberList() {
        return this.getProperty("http://schema.org/membershipNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProgramNameList() {
        return this.getProperty("http://schema.org/programName");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<ProgramMembership.Builder>
    implements ProgramMembership.Builder {
        BuilderImpl() {
        }

        @Override
        public ProgramMembership.Builder addAdditionalType(URL value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public ProgramMembership.Builder addAdditionalType(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addAlternateName(Text value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public ProgramMembership.Builder addAlternateName(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addDescription(Text value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public ProgramMembership.Builder addDescription(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addHostingOrganization(Organization value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/hostingOrganization", value);
        }

        @Override
        public ProgramMembership.Builder addHostingOrganization(Organization.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/hostingOrganization", value.build());
        }

        @Override
        public ProgramMembership.Builder addHostingOrganization(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/hostingOrganization", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addImage(ImageObject value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ProgramMembership.Builder addImage(ImageObject.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public ProgramMembership.Builder addImage(URL value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ProgramMembership.Builder addImage(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addMainEntityOfPage(CreativeWork value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ProgramMembership.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public ProgramMembership.Builder addMainEntityOfPage(URL value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ProgramMembership.Builder addMainEntityOfPage(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addMember(Organization value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/member", value);
        }

        @Override
        public ProgramMembership.Builder addMember(Organization.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/member", value.build());
        }

        @Override
        public ProgramMembership.Builder addMember(Person value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/member", value);
        }

        @Override
        public ProgramMembership.Builder addMember(Person.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/member", value.build());
        }

        @Override
        public ProgramMembership.Builder addMember(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/member", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addMembers(Organization value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/members", value);
        }

        @Override
        public ProgramMembership.Builder addMembers(Organization.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/members", value.build());
        }

        @Override
        public ProgramMembership.Builder addMembers(Person value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/members", value);
        }

        @Override
        public ProgramMembership.Builder addMembers(Person.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/members", value.build());
        }

        @Override
        public ProgramMembership.Builder addMembers(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/members", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addMembershipNumber(Text value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/membershipNumber", value);
        }

        @Override
        public ProgramMembership.Builder addMembershipNumber(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/membershipNumber", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addName(Text value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public ProgramMembership.Builder addName(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addPotentialAction(Action value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public ProgramMembership.Builder addPotentialAction(Action.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public ProgramMembership.Builder addPotentialAction(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addProgramName(Text value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/programName", value);
        }

        @Override
        public ProgramMembership.Builder addProgramName(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/programName", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addSameAs(URL value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public ProgramMembership.Builder addSameAs(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addUrl(URL value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public ProgramMembership.Builder addUrl(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addDetailedDescription(Article value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public ProgramMembership.Builder addDetailedDescription(Article.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public ProgramMembership.Builder addDetailedDescription(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public ProgramMembership.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public ProgramMembership.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public ProgramMembership.Builder addPopularityScore(String value) {
            return (ProgramMembership.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public ProgramMembership build() {
            return new ProgramMembershipImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

