/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Role;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class RoleImpl
extends IntangibleImpl
implements Role {
    private static final ImmutableSet<String> PROPERTY_SET = RoleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/namedPosition");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/roleName");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public RoleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Role";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getEndDateList() {
        return this.getProperty("http://schema.org/endDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNamedPositionList() {
        return this.getProperty("http://schema.org/namedPosition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRoleNameList() {
        return this.getProperty("http://schema.org/roleName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStartDateList() {
        return this.getProperty("http://schema.org/startDate");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Role.Builder>
    implements Role.Builder {
        BuilderImpl() {
        }

        @Override
        public Role.Builder addAdditionalType(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Role.Builder addAdditionalType(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Role.Builder addAlternateName(Text value) {
            return (Role.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Role.Builder addAlternateName(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Role.Builder addDescription(Text value) {
            return (Role.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Role.Builder addDescription(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Role.Builder addEndDate(Date value) {
            return (Role.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public Role.Builder addEndDate(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public Role.Builder addImage(ImageObject value) {
            return (Role.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Role.Builder addImage(ImageObject.Builder value) {
            return (Role.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Role.Builder addImage(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Role.Builder addImage(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Role.Builder addMainEntityOfPage(CreativeWork value) {
            return (Role.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Role.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Role.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Role.Builder addMainEntityOfPage(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Role.Builder addMainEntityOfPage(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Role.Builder addName(Text value) {
            return (Role.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Role.Builder addName(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Role.Builder addNamedPosition(Text value) {
            return (Role.Builder)this.addProperty("http://schema.org/namedPosition", value);
        }

        @Override
        public Role.Builder addNamedPosition(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/namedPosition", value);
        }

        @Override
        public Role.Builder addNamedPosition(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/namedPosition", Text.of(value));
        }

        @Override
        public Role.Builder addPotentialAction(Action value) {
            return (Role.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Role.Builder addPotentialAction(Action.Builder value) {
            return (Role.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Role.Builder addPotentialAction(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Role.Builder addRoleName(Text value) {
            return (Role.Builder)this.addProperty("http://schema.org/roleName", value);
        }

        @Override
        public Role.Builder addRoleName(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/roleName", value);
        }

        @Override
        public Role.Builder addRoleName(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/roleName", Text.of(value));
        }

        @Override
        public Role.Builder addSameAs(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Role.Builder addSameAs(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Role.Builder addStartDate(Date value) {
            return (Role.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public Role.Builder addStartDate(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public Role.Builder addUrl(URL value) {
            return (Role.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Role.Builder addUrl(String value) {
            return (Role.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Role.Builder addDetailedDescription(Article value) {
            return (Role.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Role.Builder addDetailedDescription(Article.Builder value) {
            return (Role.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Role.Builder addDetailedDescription(String value) {
            return (Role.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Role.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Role.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Role.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Role.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Role.Builder addPopularityScore(String value) {
            return (Role.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Role build() {
            return new RoleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

