/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Season;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class SeasonImpl
extends CreativeWorkImpl
implements Season {
    private static final ImmutableSet<String> PROPERTY_SET = SeasonImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public SeasonImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Season";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Season.Builder>
    implements Season.Builder {
        BuilderImpl() {
        }

        @Override
        public Season.Builder addAbout(Thing value) {
            return (Season.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Season.Builder addAbout(Thing.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Season.Builder addAbout(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Season.Builder addAccessibilityAPI(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Season.Builder addAccessibilityAPI(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Season.Builder addAccessibilityControl(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Season.Builder addAccessibilityControl(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Season.Builder addAccessibilityFeature(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Season.Builder addAccessibilityFeature(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Season.Builder addAccessibilityHazard(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Season.Builder addAccessibilityHazard(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Season.Builder addAccountablePerson(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Season.Builder addAccountablePerson(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Season.Builder addAccountablePerson(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Season.Builder addAdditionalType(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Season.Builder addAdditionalType(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Season.Builder addAggregateRating(AggregateRating value) {
            return (Season.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Season.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Season.Builder addAggregateRating(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Season.Builder addAlternateName(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Season.Builder addAlternateName(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Season.Builder addAlternativeHeadline(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Season.Builder addAlternativeHeadline(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Season.Builder addAssociatedMedia(MediaObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Season.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Season.Builder addAssociatedMedia(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Season.Builder addAudience(Audience value) {
            return (Season.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Season.Builder addAudience(Audience.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Season.Builder addAudience(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Season.Builder addAudio(AudioObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Season.Builder addAudio(AudioObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Season.Builder addAudio(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Season.Builder addAuthor(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Season.Builder addAuthor(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Season.Builder addAuthor(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Season.Builder addAuthor(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Season.Builder addAuthor(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Season.Builder addAward(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Season.Builder addAward(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Season.Builder addAwards(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Season.Builder addAwards(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Season.Builder addCharacter(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Season.Builder addCharacter(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Season.Builder addCharacter(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Season.Builder addCitation(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Season.Builder addCitation(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Season.Builder addCitation(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Season.Builder addCitation(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Season.Builder addComment(Comment value) {
            return (Season.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Season.Builder addComment(Comment.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Season.Builder addComment(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Season.Builder addCommentCount(Integer value) {
            return (Season.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Season.Builder addCommentCount(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Season.Builder addContentLocation(Place value) {
            return (Season.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Season.Builder addContentLocation(Place.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Season.Builder addContentLocation(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Season.Builder addContentRating(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Season.Builder addContentRating(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Season.Builder addContributor(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Season.Builder addContributor(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Season.Builder addContributor(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Season.Builder addContributor(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Season.Builder addContributor(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Season.Builder addCopyrightHolder(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Season.Builder addCopyrightHolder(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Season.Builder addCopyrightHolder(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Season.Builder addCopyrightHolder(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Season.Builder addCopyrightHolder(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Season.Builder addCopyrightYear(Number value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Season.Builder addCopyrightYear(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Season.Builder addCreator(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Season.Builder addCreator(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Season.Builder addCreator(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Season.Builder addCreator(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Season.Builder addCreator(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Season.Builder addDateCreated(Date value) {
            return (Season.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Season.Builder addDateCreated(DateTime value) {
            return (Season.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Season.Builder addDateCreated(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Season.Builder addDateModified(Date value) {
            return (Season.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Season.Builder addDateModified(DateTime value) {
            return (Season.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Season.Builder addDateModified(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Season.Builder addDatePublished(Date value) {
            return (Season.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Season.Builder addDatePublished(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Season.Builder addDescription(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Season.Builder addDescription(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Season.Builder addDiscussionUrl(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Season.Builder addDiscussionUrl(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Season.Builder addEditor(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Season.Builder addEditor(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Season.Builder addEditor(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Season.Builder addEducationalAlignment(AlignmentObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Season.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Season.Builder addEducationalAlignment(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Season.Builder addEducationalUse(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Season.Builder addEducationalUse(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Season.Builder addEncoding(MediaObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Season.Builder addEncoding(MediaObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Season.Builder addEncoding(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Season.Builder addEncodings(MediaObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Season.Builder addEncodings(MediaObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Season.Builder addEncodings(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Season.Builder addExampleOfWork(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Season.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Season.Builder addExampleOfWork(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Season.Builder addFileFormat(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Season.Builder addFileFormat(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Season.Builder addGenre(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Season.Builder addGenre(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Season.Builder addGenre(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Season.Builder addHasPart(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Season.Builder addHasPart(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Season.Builder addHasPart(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Season.Builder addHeadline(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Season.Builder addHeadline(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Season.Builder addImage(ImageObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Season.Builder addImage(ImageObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Season.Builder addImage(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Season.Builder addImage(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Season.Builder addInLanguage(Language value) {
            return (Season.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Season.Builder addInLanguage(Language.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Season.Builder addInLanguage(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Season.Builder addInLanguage(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Season.Builder addInteractionStatistic(InteractionCounter value) {
            return (Season.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Season.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Season.Builder addInteractionStatistic(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Season.Builder addInteractivityType(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Season.Builder addInteractivityType(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Season.Builder addIsBasedOnUrl(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Season.Builder addIsBasedOnUrl(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Season.Builder addIsFamilyFriendly(Boolean value) {
            return (Season.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Season.Builder addIsFamilyFriendly(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Season.Builder addIsPartOf(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Season.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Season.Builder addIsPartOf(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Season.Builder addKeywords(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Season.Builder addKeywords(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Season.Builder addLearningResourceType(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Season.Builder addLearningResourceType(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Season.Builder addLicense(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Season.Builder addLicense(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Season.Builder addLicense(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Season.Builder addLicense(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Season.Builder addLocationCreated(Place value) {
            return (Season.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Season.Builder addLocationCreated(Place.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Season.Builder addLocationCreated(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Season.Builder addMainEntity(Thing value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Season.Builder addMainEntity(Thing.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Season.Builder addMainEntity(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Season.Builder addMainEntityOfPage(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Season.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Season.Builder addMainEntityOfPage(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Season.Builder addMainEntityOfPage(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Season.Builder addMentions(Thing value) {
            return (Season.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Season.Builder addMentions(Thing.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Season.Builder addMentions(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Season.Builder addName(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Season.Builder addName(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Season.Builder addOffers(Offer value) {
            return (Season.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Season.Builder addOffers(Offer.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Season.Builder addOffers(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Season.Builder addPosition(Integer value) {
            return (Season.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Season.Builder addPosition(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Season.Builder addPosition(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Season.Builder addPotentialAction(Action value) {
            return (Season.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Season.Builder addPotentialAction(Action.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Season.Builder addPotentialAction(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Season.Builder addProducer(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Season.Builder addProducer(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Season.Builder addProducer(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Season.Builder addProducer(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Season.Builder addProducer(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Season.Builder addProvider(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Season.Builder addProvider(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Season.Builder addProvider(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Season.Builder addProvider(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Season.Builder addProvider(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Season.Builder addPublication(PublicationEvent value) {
            return (Season.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Season.Builder addPublication(PublicationEvent.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Season.Builder addPublication(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Season.Builder addPublisher(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Season.Builder addPublisher(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Season.Builder addPublisher(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Season.Builder addPublisher(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Season.Builder addPublisher(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Season.Builder addPublishingPrinciples(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Season.Builder addPublishingPrinciples(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Season.Builder addRecordedAt(Event value) {
            return (Season.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Season.Builder addRecordedAt(Event.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Season.Builder addRecordedAt(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Season.Builder addReleasedEvent(PublicationEvent value) {
            return (Season.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Season.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Season.Builder addReleasedEvent(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Season.Builder addReview(Review value) {
            return (Season.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Season.Builder addReview(Review.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Season.Builder addReview(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Season.Builder addReviews(Review value) {
            return (Season.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Season.Builder addReviews(Review.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Season.Builder addReviews(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Season.Builder addSameAs(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Season.Builder addSameAs(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Season.Builder addSchemaVersion(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Season.Builder addSchemaVersion(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Season.Builder addSchemaVersion(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Season.Builder addSourceOrganization(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Season.Builder addSourceOrganization(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Season.Builder addSourceOrganization(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Season.Builder addText(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Season.Builder addText(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Season.Builder addThumbnailUrl(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Season.Builder addThumbnailUrl(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Season.Builder addTimeRequired(Duration value) {
            return (Season.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Season.Builder addTimeRequired(Duration.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Season.Builder addTimeRequired(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Season.Builder addTranslator(Organization value) {
            return (Season.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Season.Builder addTranslator(Organization.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Season.Builder addTranslator(Person value) {
            return (Season.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Season.Builder addTranslator(Person.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Season.Builder addTranslator(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Season.Builder addTypicalAgeRange(Text value) {
            return (Season.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Season.Builder addTypicalAgeRange(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Season.Builder addUrl(URL value) {
            return (Season.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Season.Builder addUrl(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Season.Builder addVersion(Number value) {
            return (Season.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Season.Builder addVersion(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Season.Builder addVideo(VideoObject value) {
            return (Season.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Season.Builder addVideo(VideoObject.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Season.Builder addVideo(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Season.Builder addWorkExample(CreativeWork value) {
            return (Season.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Season.Builder addWorkExample(CreativeWork.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Season.Builder addWorkExample(String value) {
            return (Season.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Season.Builder addDetailedDescription(Article value) {
            return (Season.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Season.Builder addDetailedDescription(Article.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Season.Builder addDetailedDescription(String value) {
            return (Season.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Season.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Season.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Season.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Season.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Season.Builder addPopularityScore(String value) {
            return (Season.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Season build() {
            return new SeasonImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

