/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndicationImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.TreatmentIndication;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TreatmentIndicationImpl
extends MedicalIndicationImpl
implements TreatmentIndication {
    private static final ImmutableSet<String> PROPERTY_SET = TreatmentIndicationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TreatmentIndicationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/TreatmentIndication";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<TreatmentIndication.Builder>
    implements TreatmentIndication.Builder {
        BuilderImpl() {
        }

        @Override
        public TreatmentIndication.Builder addAdditionalType(URL value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public TreatmentIndication.Builder addAdditionalType(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addAlternateName(Text value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public TreatmentIndication.Builder addAlternateName(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addCode(MedicalCode value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public TreatmentIndication.Builder addCode(MedicalCode.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public TreatmentIndication.Builder addCode(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addDescription(Text value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public TreatmentIndication.Builder addDescription(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addGuideline(MedicalGuideline value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public TreatmentIndication.Builder addGuideline(MedicalGuideline.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public TreatmentIndication.Builder addGuideline(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addImage(ImageObject value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TreatmentIndication.Builder addImage(ImageObject.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public TreatmentIndication.Builder addImage(URL value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public TreatmentIndication.Builder addImage(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addMainEntityOfPage(CreativeWork value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TreatmentIndication.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public TreatmentIndication.Builder addMainEntityOfPage(URL value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public TreatmentIndication.Builder addMainEntityOfPage(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addMedicineSystem(MedicineSystem value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public TreatmentIndication.Builder addMedicineSystem(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addName(Text value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public TreatmentIndication.Builder addName(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addPotentialAction(Action value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public TreatmentIndication.Builder addPotentialAction(Action.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public TreatmentIndication.Builder addPotentialAction(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addRecognizingAuthority(Organization value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public TreatmentIndication.Builder addRecognizingAuthority(Organization.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public TreatmentIndication.Builder addRecognizingAuthority(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public TreatmentIndication.Builder addRelevantSpecialty(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addSameAs(URL value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public TreatmentIndication.Builder addSameAs(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addStudy(MedicalStudy value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public TreatmentIndication.Builder addStudy(MedicalStudy.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public TreatmentIndication.Builder addStudy(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addUrl(URL value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public TreatmentIndication.Builder addUrl(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addDetailedDescription(Article value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public TreatmentIndication.Builder addDetailedDescription(Article.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public TreatmentIndication.Builder addDetailedDescription(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public TreatmentIndication.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public TreatmentIndication.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public TreatmentIndication.Builder addPopularityScore(String value) {
            return (TreatmentIndication.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public TreatmentIndication build() {
            return new TreatmentIndicationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

