/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.schemaorg.NullValue;
import com.google.schemaorg.SchemaOrgException;
import com.google.schemaorg.ValueType;
import javax.annotation.Nullable;

abstract class BaseTypeImpl
implements ValueType {
    protected final ImmutableListMultimap<String, ValueType> properties;

    BaseTypeImpl(Multimap<String, ValueType> properties) {
        this.properties = ImmutableListMultimap.copyOf(properties);
    }

    protected boolean containsProperty(String name) {
        return this.properties.containsKey((Object)name);
    }

    @Nullable
    protected ValueType getSingleValueProperty(String name) throws SchemaOrgException {
        ImmutableList<ValueType> list = this.getPropertyList(name);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new SchemaOrgException(String.format("Multiple value found in the single-value property %s", name));
        }
        ValueType res = (ValueType)list.get(0);
        return res == NullValue.VALUE ? null : res;
    }

    protected ImmutableList<ValueType> getPropertyList(String property) {
        return this.properties.get((Object)property);
    }

    ImmutableListMultimap<String, ValueType> getAllProperties() {
        return this.properties;
    }

    static abstract class BuilderImpl<T extends ValueType.Builder>
    implements ValueType.Builder {
        protected final Multimap<String, ValueType> properties = LinkedListMultimap.create();

        BuilderImpl() {
        }

        protected T addPropertyValue(String name, @Nullable ValueType value) {
            Preconditions.checkNotNull((Object)name, (Object)"property name is null");
            this.properties.put((Object)name, (Object)(value == null ? NullValue.VALUE : value));
            return (T)this;
        }

        protected T setSingleValueProperty(String name, @Nullable ValueType value) {
            Preconditions.checkNotNull((Object)name, (Object)"property name is null");
            this.properties.removeAll((Object)name);
            this.properties.put((Object)name, (Object)(value == null ? NullValue.VALUE : value));
            return (T)this;
        }
    }
}

