/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Artery;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VesselImpl;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ArteryImpl
extends VesselImpl
implements Artery {
    private static final ImmutableSet<String> PROPERTY_SET = ArteryImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/arterialBranch");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/source");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/supplyTo");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ArteryImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Artery";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getArterialBranchList() {
        return this.getProperty("http://schema.org/arterialBranch");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSourceList() {
        return this.getProperty("http://schema.org/source");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSupplyToList() {
        return this.getProperty("http://schema.org/supplyTo");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Artery.Builder>
    implements Artery.Builder {
        BuilderImpl() {
        }

        @Override
        public Artery.Builder addAdditionalType(URL value) {
            return (Artery.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Artery.Builder addAdditionalType(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Artery.Builder addAlternateName(Text value) {
            return (Artery.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Artery.Builder addAlternateName(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Artery.Builder addArterialBranch(AnatomicalStructure value) {
            return (Artery.Builder)this.addProperty("http://schema.org/arterialBranch", value);
        }

        @Override
        public Artery.Builder addArterialBranch(AnatomicalStructure.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/arterialBranch", value.build());
        }

        @Override
        public Artery.Builder addArterialBranch(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/arterialBranch", Text.of(value));
        }

        @Override
        public Artery.Builder addAssociatedPathophysiology(Text value) {
            return (Artery.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public Artery.Builder addAssociatedPathophysiology(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public Artery.Builder addBodyLocation(Text value) {
            return (Artery.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public Artery.Builder addBodyLocation(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public Artery.Builder addCode(MedicalCode value) {
            return (Artery.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Artery.Builder addCode(MedicalCode.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Artery.Builder addCode(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Artery.Builder addConnectedTo(AnatomicalStructure value) {
            return (Artery.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public Artery.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public Artery.Builder addConnectedTo(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public Artery.Builder addDescription(Text value) {
            return (Artery.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Artery.Builder addDescription(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Artery.Builder addDiagram(ImageObject value) {
            return (Artery.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public Artery.Builder addDiagram(ImageObject.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public Artery.Builder addDiagram(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public Artery.Builder addFunction(Text value) {
            return (Artery.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public Artery.Builder addFunction(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public Artery.Builder addGuideline(MedicalGuideline value) {
            return (Artery.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Artery.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Artery.Builder addGuideline(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Artery.Builder addImage(ImageObject value) {
            return (Artery.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Artery.Builder addImage(ImageObject.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Artery.Builder addImage(URL value) {
            return (Artery.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Artery.Builder addImage(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Artery.Builder addMainEntityOfPage(CreativeWork value) {
            return (Artery.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Artery.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Artery.Builder addMainEntityOfPage(URL value) {
            return (Artery.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Artery.Builder addMainEntityOfPage(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Artery.Builder addMedicineSystem(MedicineSystem value) {
            return (Artery.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Artery.Builder addMedicineSystem(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Artery.Builder addName(Text value) {
            return (Artery.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Artery.Builder addName(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Artery.Builder addPartOfSystem(AnatomicalSystem value) {
            return (Artery.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public Artery.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public Artery.Builder addPartOfSystem(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public Artery.Builder addPotentialAction(Action value) {
            return (Artery.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Artery.Builder addPotentialAction(Action.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Artery.Builder addPotentialAction(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Artery.Builder addRecognizingAuthority(Organization value) {
            return (Artery.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Artery.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Artery.Builder addRecognizingAuthority(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Artery.Builder addRelatedCondition(MedicalCondition value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public Artery.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public Artery.Builder addRelatedCondition(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public Artery.Builder addRelatedTherapy(MedicalTherapy value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public Artery.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public Artery.Builder addRelatedTherapy(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public Artery.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Artery.Builder addRelevantSpecialty(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Artery.Builder addSameAs(URL value) {
            return (Artery.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Artery.Builder addSameAs(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Artery.Builder addSource(AnatomicalStructure value) {
            return (Artery.Builder)this.addProperty("http://schema.org/source", value);
        }

        @Override
        public Artery.Builder addSource(AnatomicalStructure.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/source", value.build());
        }

        @Override
        public Artery.Builder addSource(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/source", Text.of(value));
        }

        @Override
        public Artery.Builder addStudy(MedicalStudy value) {
            return (Artery.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Artery.Builder addStudy(MedicalStudy.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Artery.Builder addStudy(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Artery.Builder addSubStructure(AnatomicalStructure value) {
            return (Artery.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public Artery.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public Artery.Builder addSubStructure(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public Artery.Builder addSupplyTo(AnatomicalStructure value) {
            return (Artery.Builder)this.addProperty("http://schema.org/supplyTo", value);
        }

        @Override
        public Artery.Builder addSupplyTo(AnatomicalStructure.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.org/supplyTo", value.build());
        }

        @Override
        public Artery.Builder addSupplyTo(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/supplyTo", Text.of(value));
        }

        @Override
        public Artery.Builder addUrl(URL value) {
            return (Artery.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Artery.Builder addUrl(String value) {
            return (Artery.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Artery.Builder addDetailedDescription(Article value) {
            return (Artery.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Artery.Builder addDetailedDescription(Article.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Artery.Builder addDetailedDescription(String value) {
            return (Artery.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Artery.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Artery.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Artery.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Artery.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Artery.Builder addPopularityScore(String value) {
            return (Artery.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Artery build() {
            return new ArteryImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

