/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ArticleImpl
extends CreativeWorkImpl
implements Article {
    private static final ImmutableSet<String> PROPERTY_SET = ArticleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/articleBody");
        builder.add((Object)"http://schema.org/articleSection");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/pageEnd");
        builder.add((Object)"http://schema.org/pageStart");
        builder.add((Object)"http://schema.org/pagination");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/wordCount");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ArticleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Article";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getArticleBodyList() {
        return this.getProperty("http://schema.org/articleBody");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArticleSectionList() {
        return this.getProperty("http://schema.org/articleSection");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPageEndList() {
        return this.getProperty("http://schema.org/pageEnd");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPageStartList() {
        return this.getProperty("http://schema.org/pageStart");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaginationList() {
        return this.getProperty("http://schema.org/pagination");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWordCountList() {
        return this.getProperty("http://schema.org/wordCount");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Article.Builder>
    implements Article.Builder {
        BuilderImpl() {
        }

        @Override
        public Article.Builder addAbout(Thing value) {
            return (Article.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Article.Builder addAbout(Thing.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Article.Builder addAbout(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Article.Builder addAccessibilityAPI(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Article.Builder addAccessibilityAPI(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Article.Builder addAccessibilityControl(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Article.Builder addAccessibilityControl(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Article.Builder addAccessibilityFeature(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Article.Builder addAccessibilityFeature(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Article.Builder addAccessibilityHazard(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Article.Builder addAccessibilityHazard(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Article.Builder addAccountablePerson(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Article.Builder addAccountablePerson(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Article.Builder addAccountablePerson(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Article.Builder addAdditionalType(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Article.Builder addAdditionalType(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Article.Builder addAggregateRating(AggregateRating value) {
            return (Article.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Article.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Article.Builder addAggregateRating(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Article.Builder addAlternateName(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Article.Builder addAlternateName(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Article.Builder addAlternativeHeadline(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Article.Builder addAlternativeHeadline(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Article.Builder addArticleBody(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/articleBody", value);
        }

        @Override
        public Article.Builder addArticleBody(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/articleBody", Text.of(value));
        }

        @Override
        public Article.Builder addArticleSection(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/articleSection", value);
        }

        @Override
        public Article.Builder addArticleSection(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/articleSection", Text.of(value));
        }

        @Override
        public Article.Builder addAssociatedMedia(MediaObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Article.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Article.Builder addAssociatedMedia(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Article.Builder addAudience(Audience value) {
            return (Article.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Article.Builder addAudience(Audience.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Article.Builder addAudience(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Article.Builder addAudio(AudioObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Article.Builder addAudio(AudioObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Article.Builder addAudio(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Article.Builder addAuthor(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Article.Builder addAuthor(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Article.Builder addAuthor(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Article.Builder addAuthor(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Article.Builder addAuthor(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Article.Builder addAward(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Article.Builder addAward(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Article.Builder addAwards(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Article.Builder addAwards(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Article.Builder addCharacter(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Article.Builder addCharacter(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Article.Builder addCharacter(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Article.Builder addCitation(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Article.Builder addCitation(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Article.Builder addCitation(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Article.Builder addCitation(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Article.Builder addComment(Comment value) {
            return (Article.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Article.Builder addComment(Comment.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Article.Builder addComment(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Article.Builder addCommentCount(Integer value) {
            return (Article.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Article.Builder addCommentCount(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Article.Builder addContentLocation(Place value) {
            return (Article.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Article.Builder addContentLocation(Place.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Article.Builder addContentLocation(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Article.Builder addContentRating(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Article.Builder addContentRating(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Article.Builder addContributor(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Article.Builder addContributor(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Article.Builder addContributor(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Article.Builder addContributor(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Article.Builder addContributor(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Article.Builder addCopyrightHolder(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Article.Builder addCopyrightHolder(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Article.Builder addCopyrightHolder(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Article.Builder addCopyrightHolder(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Article.Builder addCopyrightHolder(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Article.Builder addCopyrightYear(Number value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Article.Builder addCopyrightYear(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Article.Builder addCreator(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Article.Builder addCreator(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Article.Builder addCreator(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Article.Builder addCreator(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Article.Builder addCreator(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Article.Builder addDateCreated(Date value) {
            return (Article.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Article.Builder addDateCreated(DateTime value) {
            return (Article.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Article.Builder addDateCreated(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Article.Builder addDateModified(Date value) {
            return (Article.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Article.Builder addDateModified(DateTime value) {
            return (Article.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Article.Builder addDateModified(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Article.Builder addDatePublished(Date value) {
            return (Article.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Article.Builder addDatePublished(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Article.Builder addDescription(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Article.Builder addDescription(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Article.Builder addDiscussionUrl(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Article.Builder addDiscussionUrl(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Article.Builder addEditor(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Article.Builder addEditor(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Article.Builder addEditor(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Article.Builder addEducationalAlignment(AlignmentObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Article.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Article.Builder addEducationalAlignment(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Article.Builder addEducationalUse(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Article.Builder addEducationalUse(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Article.Builder addEncoding(MediaObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Article.Builder addEncoding(MediaObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Article.Builder addEncoding(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Article.Builder addEncodings(MediaObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Article.Builder addEncodings(MediaObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Article.Builder addEncodings(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Article.Builder addExampleOfWork(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Article.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Article.Builder addExampleOfWork(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Article.Builder addFileFormat(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Article.Builder addFileFormat(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Article.Builder addGenre(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Article.Builder addGenre(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Article.Builder addGenre(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Article.Builder addHasPart(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Article.Builder addHasPart(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Article.Builder addHasPart(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Article.Builder addHeadline(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Article.Builder addHeadline(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Article.Builder addImage(ImageObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Article.Builder addImage(ImageObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Article.Builder addImage(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Article.Builder addImage(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Article.Builder addInLanguage(Language value) {
            return (Article.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Article.Builder addInLanguage(Language.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Article.Builder addInLanguage(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Article.Builder addInLanguage(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Article.Builder addInteractionStatistic(InteractionCounter value) {
            return (Article.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Article.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Article.Builder addInteractionStatistic(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Article.Builder addInteractivityType(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Article.Builder addInteractivityType(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Article.Builder addIsBasedOnUrl(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Article.Builder addIsBasedOnUrl(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Article.Builder addIsFamilyFriendly(Boolean value) {
            return (Article.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Article.Builder addIsFamilyFriendly(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Article.Builder addIsPartOf(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Article.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Article.Builder addIsPartOf(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Article.Builder addKeywords(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Article.Builder addKeywords(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Article.Builder addLearningResourceType(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Article.Builder addLearningResourceType(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Article.Builder addLicense(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Article.Builder addLicense(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Article.Builder addLicense(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Article.Builder addLicense(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Article.Builder addLocationCreated(Place value) {
            return (Article.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Article.Builder addLocationCreated(Place.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Article.Builder addLocationCreated(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Article.Builder addMainEntity(Thing value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Article.Builder addMainEntity(Thing.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Article.Builder addMainEntity(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Article.Builder addMainEntityOfPage(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Article.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Article.Builder addMainEntityOfPage(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Article.Builder addMainEntityOfPage(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Article.Builder addMentions(Thing value) {
            return (Article.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Article.Builder addMentions(Thing.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Article.Builder addMentions(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Article.Builder addName(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Article.Builder addName(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Article.Builder addOffers(Offer value) {
            return (Article.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Article.Builder addOffers(Offer.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Article.Builder addOffers(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Article.Builder addPageEnd(Integer value) {
            return (Article.Builder)this.addProperty("http://schema.org/pageEnd", value);
        }

        @Override
        public Article.Builder addPageEnd(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/pageEnd", value);
        }

        @Override
        public Article.Builder addPageEnd(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/pageEnd", Text.of(value));
        }

        @Override
        public Article.Builder addPageStart(Integer value) {
            return (Article.Builder)this.addProperty("http://schema.org/pageStart", value);
        }

        @Override
        public Article.Builder addPageStart(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/pageStart", value);
        }

        @Override
        public Article.Builder addPageStart(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/pageStart", Text.of(value));
        }

        @Override
        public Article.Builder addPagination(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/pagination", value);
        }

        @Override
        public Article.Builder addPagination(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/pagination", Text.of(value));
        }

        @Override
        public Article.Builder addPosition(Integer value) {
            return (Article.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Article.Builder addPosition(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Article.Builder addPosition(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Article.Builder addPotentialAction(Action value) {
            return (Article.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Article.Builder addPotentialAction(Action.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Article.Builder addPotentialAction(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Article.Builder addProducer(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Article.Builder addProducer(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Article.Builder addProducer(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Article.Builder addProducer(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Article.Builder addProducer(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Article.Builder addProvider(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Article.Builder addProvider(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Article.Builder addProvider(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Article.Builder addProvider(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Article.Builder addProvider(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Article.Builder addPublication(PublicationEvent value) {
            return (Article.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Article.Builder addPublication(PublicationEvent.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Article.Builder addPublication(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Article.Builder addPublisher(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Article.Builder addPublisher(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Article.Builder addPublisher(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Article.Builder addPublisher(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Article.Builder addPublisher(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Article.Builder addPublishingPrinciples(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Article.Builder addPublishingPrinciples(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Article.Builder addRecordedAt(Event value) {
            return (Article.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Article.Builder addRecordedAt(Event.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Article.Builder addRecordedAt(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Article.Builder addReleasedEvent(PublicationEvent value) {
            return (Article.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Article.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Article.Builder addReleasedEvent(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Article.Builder addReview(Review value) {
            return (Article.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Article.Builder addReview(Review.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Article.Builder addReview(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Article.Builder addReviews(Review value) {
            return (Article.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Article.Builder addReviews(Review.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Article.Builder addReviews(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Article.Builder addSameAs(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Article.Builder addSameAs(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Article.Builder addSchemaVersion(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Article.Builder addSchemaVersion(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Article.Builder addSchemaVersion(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Article.Builder addSourceOrganization(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Article.Builder addSourceOrganization(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Article.Builder addSourceOrganization(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Article.Builder addText(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Article.Builder addText(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Article.Builder addThumbnailUrl(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Article.Builder addThumbnailUrl(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Article.Builder addTimeRequired(Duration value) {
            return (Article.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Article.Builder addTimeRequired(Duration.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Article.Builder addTimeRequired(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Article.Builder addTranslator(Organization value) {
            return (Article.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Article.Builder addTranslator(Organization.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Article.Builder addTranslator(Person value) {
            return (Article.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Article.Builder addTranslator(Person.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Article.Builder addTranslator(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Article.Builder addTypicalAgeRange(Text value) {
            return (Article.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Article.Builder addTypicalAgeRange(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Article.Builder addUrl(URL value) {
            return (Article.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Article.Builder addUrl(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Article.Builder addVersion(Number value) {
            return (Article.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Article.Builder addVersion(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Article.Builder addVideo(VideoObject value) {
            return (Article.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Article.Builder addVideo(VideoObject.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Article.Builder addVideo(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Article.Builder addWordCount(Integer value) {
            return (Article.Builder)this.addProperty("http://schema.org/wordCount", value);
        }

        @Override
        public Article.Builder addWordCount(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/wordCount", Text.of(value));
        }

        @Override
        public Article.Builder addWorkExample(CreativeWork value) {
            return (Article.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Article.Builder addWorkExample(CreativeWork.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Article.Builder addWorkExample(String value) {
            return (Article.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Article.Builder addDetailedDescription(Article value) {
            return (Article.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Article.Builder addDetailedDescription(Article.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Article.Builder addDetailedDescription(String value) {
            return (Article.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Article.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Article.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Article.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Article.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Article.Builder addPopularityScore(String value) {
            return (Article.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Article build() {
            return new ArticleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

