/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalStructureImpl;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BrainStructure;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BrainStructureImpl
extends AnatomicalStructureImpl
implements BrainStructure {
    private static final ImmutableSet<String> PROPERTY_SET = BrainStructureImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BrainStructureImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BrainStructure";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BrainStructure.Builder>
    implements BrainStructure.Builder {
        BuilderImpl() {
        }

        @Override
        public BrainStructure.Builder addAdditionalType(URL value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BrainStructure.Builder addAdditionalType(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addAlternateName(Text value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BrainStructure.Builder addAlternateName(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addAssociatedPathophysiology(Text value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public BrainStructure.Builder addAssociatedPathophysiology(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addBodyLocation(Text value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public BrainStructure.Builder addBodyLocation(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addCode(MedicalCode value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public BrainStructure.Builder addCode(MedicalCode.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public BrainStructure.Builder addCode(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addConnectedTo(AnatomicalStructure value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public BrainStructure.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public BrainStructure.Builder addConnectedTo(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addDescription(Text value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BrainStructure.Builder addDescription(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addDiagram(ImageObject value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public BrainStructure.Builder addDiagram(ImageObject.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public BrainStructure.Builder addDiagram(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addFunction(Text value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public BrainStructure.Builder addFunction(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addGuideline(MedicalGuideline value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public BrainStructure.Builder addGuideline(MedicalGuideline.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public BrainStructure.Builder addGuideline(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addImage(ImageObject value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BrainStructure.Builder addImage(ImageObject.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BrainStructure.Builder addImage(URL value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BrainStructure.Builder addImage(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addMainEntityOfPage(CreativeWork value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BrainStructure.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BrainStructure.Builder addMainEntityOfPage(URL value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BrainStructure.Builder addMainEntityOfPage(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addMedicineSystem(MedicineSystem value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public BrainStructure.Builder addMedicineSystem(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addName(Text value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BrainStructure.Builder addName(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addPartOfSystem(AnatomicalSystem value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public BrainStructure.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public BrainStructure.Builder addPartOfSystem(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addPotentialAction(Action value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BrainStructure.Builder addPotentialAction(Action.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BrainStructure.Builder addPotentialAction(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addRecognizingAuthority(Organization value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public BrainStructure.Builder addRecognizingAuthority(Organization.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public BrainStructure.Builder addRecognizingAuthority(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addRelatedCondition(MedicalCondition value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public BrainStructure.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public BrainStructure.Builder addRelatedCondition(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addRelatedTherapy(MedicalTherapy value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public BrainStructure.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public BrainStructure.Builder addRelatedTherapy(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public BrainStructure.Builder addRelevantSpecialty(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addSameAs(URL value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BrainStructure.Builder addSameAs(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addStudy(MedicalStudy value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public BrainStructure.Builder addStudy(MedicalStudy.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public BrainStructure.Builder addStudy(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addSubStructure(AnatomicalStructure value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public BrainStructure.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public BrainStructure.Builder addSubStructure(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addUrl(URL value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BrainStructure.Builder addUrl(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addDetailedDescription(Article value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BrainStructure.Builder addDetailedDescription(Article.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BrainStructure.Builder addDetailedDescription(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BrainStructure.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BrainStructure.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BrainStructure.Builder addPopularityScore(String value) {
            return (BrainStructure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BrainStructure build() {
            return new BrainStructureImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

