/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Brand;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BrandImpl
extends IntangibleImpl
implements Brand {
    private static final ImmutableSet<String> PROPERTY_SET = BrandImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/logo");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BrandImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Brand";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAggregateRatingList() {
        return this.getProperty("http://schema.org/aggregateRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLogoList() {
        return this.getProperty("http://schema.org/logo");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewList() {
        return this.getProperty("http://schema.org/review");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Brand.Builder>
    implements Brand.Builder {
        BuilderImpl() {
        }

        @Override
        public Brand.Builder addAdditionalType(URL value) {
            return (Brand.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Brand.Builder addAdditionalType(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Brand.Builder addAggregateRating(AggregateRating value) {
            return (Brand.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Brand.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Brand.Builder addAggregateRating(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Brand.Builder addAlternateName(Text value) {
            return (Brand.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Brand.Builder addAlternateName(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Brand.Builder addDescription(Text value) {
            return (Brand.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Brand.Builder addDescription(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Brand.Builder addImage(ImageObject value) {
            return (Brand.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Brand.Builder addImage(ImageObject.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Brand.Builder addImage(URL value) {
            return (Brand.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Brand.Builder addImage(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Brand.Builder addLogo(ImageObject value) {
            return (Brand.Builder)this.addProperty("http://schema.org/logo", value);
        }

        @Override
        public Brand.Builder addLogo(ImageObject.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.org/logo", value.build());
        }

        @Override
        public Brand.Builder addLogo(URL value) {
            return (Brand.Builder)this.addProperty("http://schema.org/logo", value);
        }

        @Override
        public Brand.Builder addLogo(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/logo", Text.of(value));
        }

        @Override
        public Brand.Builder addMainEntityOfPage(CreativeWork value) {
            return (Brand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Brand.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Brand.Builder addMainEntityOfPage(URL value) {
            return (Brand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Brand.Builder addMainEntityOfPage(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Brand.Builder addName(Text value) {
            return (Brand.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Brand.Builder addName(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Brand.Builder addPotentialAction(Action value) {
            return (Brand.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Brand.Builder addPotentialAction(Action.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Brand.Builder addPotentialAction(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Brand.Builder addReview(Review value) {
            return (Brand.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Brand.Builder addReview(Review.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Brand.Builder addReview(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Brand.Builder addSameAs(URL value) {
            return (Brand.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Brand.Builder addSameAs(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Brand.Builder addUrl(URL value) {
            return (Brand.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Brand.Builder addUrl(String value) {
            return (Brand.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Brand.Builder addDetailedDescription(Article value) {
            return (Brand.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Brand.Builder addDetailedDescription(Article.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Brand.Builder addDetailedDescription(String value) {
            return (Brand.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Brand.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Brand.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Brand.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Brand.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Brand.Builder addPopularityScore(String value) {
            return (Brand.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Brand build() {
            return new BrandImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

