/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.AudienceImpl;
import com.google.schemaorg.core.BusinessAudience;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BusinessAudienceImpl
extends AudienceImpl
implements BusinessAudience {
    private static final ImmutableSet<String> PROPERTY_SET = BusinessAudienceImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/audienceType");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/geographicArea");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numberOfEmployees");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/yearlyRevenue");
        builder.add((Object)"http://schema.org/yearsInOperation");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BusinessAudienceImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BusinessAudience";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getNumberOfEmployeesList() {
        return this.getProperty("http://schema.org/numberOfEmployees");
    }

    @Override
    public ImmutableList<SchemaOrgType> getYearlyRevenueList() {
        return this.getProperty("http://schema.org/yearlyRevenue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getYearsInOperationList() {
        return this.getProperty("http://schema.org/yearsInOperation");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BusinessAudience.Builder>
    implements BusinessAudience.Builder {
        BuilderImpl() {
        }

        @Override
        public BusinessAudience.Builder addAdditionalType(URL value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BusinessAudience.Builder addAdditionalType(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addAlternateName(Text value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BusinessAudience.Builder addAlternateName(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addAudienceType(Text value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/audienceType", value);
        }

        @Override
        public BusinessAudience.Builder addAudienceType(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/audienceType", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addDescription(Text value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BusinessAudience.Builder addDescription(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addGeographicArea(AdministrativeArea value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/geographicArea", value);
        }

        @Override
        public BusinessAudience.Builder addGeographicArea(AdministrativeArea.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/geographicArea", value.build());
        }

        @Override
        public BusinessAudience.Builder addGeographicArea(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/geographicArea", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addImage(ImageObject value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BusinessAudience.Builder addImage(ImageObject.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BusinessAudience.Builder addImage(URL value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BusinessAudience.Builder addImage(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addMainEntityOfPage(CreativeWork value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BusinessAudience.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BusinessAudience.Builder addMainEntityOfPage(URL value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BusinessAudience.Builder addMainEntityOfPage(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addName(Text value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BusinessAudience.Builder addName(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addNumberOfEmployees(QuantitativeValue value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/numberOfEmployees", value);
        }

        @Override
        public BusinessAudience.Builder addNumberOfEmployees(QuantitativeValue.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/numberOfEmployees", value.build());
        }

        @Override
        public BusinessAudience.Builder addNumberOfEmployees(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/numberOfEmployees", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addPotentialAction(Action value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BusinessAudience.Builder addPotentialAction(Action.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BusinessAudience.Builder addPotentialAction(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addSameAs(URL value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BusinessAudience.Builder addSameAs(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addUrl(URL value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BusinessAudience.Builder addUrl(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addYearlyRevenue(QuantitativeValue value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/yearlyRevenue", value);
        }

        @Override
        public BusinessAudience.Builder addYearlyRevenue(QuantitativeValue.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/yearlyRevenue", value.build());
        }

        @Override
        public BusinessAudience.Builder addYearlyRevenue(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/yearlyRevenue", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addYearsInOperation(QuantitativeValue value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/yearsInOperation", value);
        }

        @Override
        public BusinessAudience.Builder addYearsInOperation(QuantitativeValue.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/yearsInOperation", value.build());
        }

        @Override
        public BusinessAudience.Builder addYearsInOperation(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.org/yearsInOperation", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addDetailedDescription(Article value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BusinessAudience.Builder addDetailedDescription(Article.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BusinessAudience.Builder addDetailedDescription(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BusinessAudience.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BusinessAudience.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BusinessAudience.Builder addPopularityScore(String value) {
            return (BusinessAudience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BusinessAudience build() {
            return new BusinessAudienceImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

