/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BusinessEntityType;
import com.google.schemaorg.core.BusinessFunction;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DeliveryMethod;
import com.google.schemaorg.core.Demand;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.ItemAvailability;
import com.google.schemaorg.core.OfferItemCondition;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PaymentMethod;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PriceSpecification;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Service;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.TypeAndQuantityNode;
import com.google.schemaorg.core.WarrantyPromise;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DemandImpl
extends IntangibleImpl
implements Demand {
    private static final ImmutableSet<String> PROPERTY_SET = DemandImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/acceptedPaymentMethod");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/advanceBookingRequirement");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/areaServed");
        builder.add((Object)"http://schema.org/availability");
        builder.add((Object)"http://schema.org/availabilityEnds");
        builder.add((Object)"http://schema.org/availabilityStarts");
        builder.add((Object)"http://schema.org/availableAtOrFrom");
        builder.add((Object)"http://schema.org/availableDeliveryMethod");
        builder.add((Object)"http://schema.org/businessFunction");
        builder.add((Object)"http://schema.org/deliveryLeadTime");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/eligibleCustomerType");
        builder.add((Object)"http://schema.org/eligibleDuration");
        builder.add((Object)"http://schema.org/eligibleQuantity");
        builder.add((Object)"http://schema.org/eligibleRegion");
        builder.add((Object)"http://schema.org/eligibleTransactionVolume");
        builder.add((Object)"http://schema.org/gtin12");
        builder.add((Object)"http://schema.org/gtin13");
        builder.add((Object)"http://schema.org/gtin14");
        builder.add((Object)"http://schema.org/gtin8");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includesObject");
        builder.add((Object)"http://schema.org/ineligibleRegion");
        builder.add((Object)"http://schema.org/inventoryLevel");
        builder.add((Object)"http://schema.org/itemCondition");
        builder.add((Object)"http://schema.org/itemOffered");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mpn");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/priceSpecification");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seller");
        builder.add((Object)"http://schema.org/serialNumber");
        builder.add((Object)"http://schema.org/sku");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/validFrom");
        builder.add((Object)"http://schema.org/validThrough");
        builder.add((Object)"http://schema.org/warranty");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DemandImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Demand";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAcceptedPaymentMethodList() {
        return this.getProperty("http://schema.org/acceptedPaymentMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdvanceBookingRequirementList() {
        return this.getProperty("http://schema.org/advanceBookingRequirement");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAreaServedList() {
        return this.getProperty("http://schema.org/areaServed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailabilityList() {
        return this.getProperty("http://schema.org/availability");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailabilityEndsList() {
        return this.getProperty("http://schema.org/availabilityEnds");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailabilityStartsList() {
        return this.getProperty("http://schema.org/availabilityStarts");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableAtOrFromList() {
        return this.getProperty("http://schema.org/availableAtOrFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableDeliveryMethodList() {
        return this.getProperty("http://schema.org/availableDeliveryMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBusinessFunctionList() {
        return this.getProperty("http://schema.org/businessFunction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDeliveryLeadTimeList() {
        return this.getProperty("http://schema.org/deliveryLeadTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleCustomerTypeList() {
        return this.getProperty("http://schema.org/eligibleCustomerType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleDurationList() {
        return this.getProperty("http://schema.org/eligibleDuration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleQuantityList() {
        return this.getProperty("http://schema.org/eligibleQuantity");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleRegionList() {
        return this.getProperty("http://schema.org/eligibleRegion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEligibleTransactionVolumeList() {
        return this.getProperty("http://schema.org/eligibleTransactionVolume");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin12List() {
        return this.getProperty("http://schema.org/gtin12");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin13List() {
        return this.getProperty("http://schema.org/gtin13");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin14List() {
        return this.getProperty("http://schema.org/gtin14");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGtin8List() {
        return this.getProperty("http://schema.org/gtin8");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIncludesObjectList() {
        return this.getProperty("http://schema.org/includesObject");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIneligibleRegionList() {
        return this.getProperty("http://schema.org/ineligibleRegion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInventoryLevelList() {
        return this.getProperty("http://schema.org/inventoryLevel");
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemConditionList() {
        return this.getProperty("http://schema.org/itemCondition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemOfferedList() {
        return this.getProperty("http://schema.org/itemOffered");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMpnList() {
        return this.getProperty("http://schema.org/mpn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceSpecificationList() {
        return this.getProperty("http://schema.org/priceSpecification");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSellerList() {
        return this.getProperty("http://schema.org/seller");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSerialNumberList() {
        return this.getProperty("http://schema.org/serialNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSkuList() {
        return this.getProperty("http://schema.org/sku");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidFromList() {
        return this.getProperty("http://schema.org/validFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getValidThroughList() {
        return this.getProperty("http://schema.org/validThrough");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWarrantyList() {
        return this.getProperty("http://schema.org/warranty");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Demand.Builder>
    implements Demand.Builder {
        BuilderImpl() {
        }

        @Override
        public Demand.Builder addAcceptedPaymentMethod(PaymentMethod value) {
            return (Demand.Builder)this.addProperty("http://schema.org/acceptedPaymentMethod", value);
        }

        @Override
        public Demand.Builder addAcceptedPaymentMethod(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/acceptedPaymentMethod", Text.of(value));
        }

        @Override
        public Demand.Builder addAdditionalType(URL value) {
            return (Demand.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Demand.Builder addAdditionalType(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Demand.Builder addAdvanceBookingRequirement(QuantitativeValue value) {
            return (Demand.Builder)this.addProperty("http://schema.org/advanceBookingRequirement", value);
        }

        @Override
        public Demand.Builder addAdvanceBookingRequirement(QuantitativeValue.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/advanceBookingRequirement", value.build());
        }

        @Override
        public Demand.Builder addAdvanceBookingRequirement(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/advanceBookingRequirement", Text.of(value));
        }

        @Override
        public Demand.Builder addAlternateName(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Demand.Builder addAlternateName(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Demand.Builder addAreaServed(AdministrativeArea value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Demand.Builder addAreaServed(AdministrativeArea.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Demand.Builder addAreaServed(GeoShape value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Demand.Builder addAreaServed(GeoShape.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Demand.Builder addAreaServed(Place value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Demand.Builder addAreaServed(Place.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public Demand.Builder addAreaServed(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public Demand.Builder addAreaServed(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/areaServed", Text.of(value));
        }

        @Override
        public Demand.Builder addAvailability(ItemAvailability value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availability", value);
        }

        @Override
        public Demand.Builder addAvailability(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availability", Text.of(value));
        }

        @Override
        public Demand.Builder addAvailabilityEnds(DateTime value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availabilityEnds", value);
        }

        @Override
        public Demand.Builder addAvailabilityEnds(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availabilityEnds", Text.of(value));
        }

        @Override
        public Demand.Builder addAvailabilityStarts(DateTime value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availabilityStarts", value);
        }

        @Override
        public Demand.Builder addAvailabilityStarts(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availabilityStarts", Text.of(value));
        }

        @Override
        public Demand.Builder addAvailableAtOrFrom(Place value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availableAtOrFrom", value);
        }

        @Override
        public Demand.Builder addAvailableAtOrFrom(Place.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availableAtOrFrom", value.build());
        }

        @Override
        public Demand.Builder addAvailableAtOrFrom(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availableAtOrFrom", Text.of(value));
        }

        @Override
        public Demand.Builder addAvailableDeliveryMethod(DeliveryMethod value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availableDeliveryMethod", value);
        }

        @Override
        public Demand.Builder addAvailableDeliveryMethod(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/availableDeliveryMethod", Text.of(value));
        }

        @Override
        public Demand.Builder addBusinessFunction(BusinessFunction value) {
            return (Demand.Builder)this.addProperty("http://schema.org/businessFunction", value);
        }

        @Override
        public Demand.Builder addBusinessFunction(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/businessFunction", Text.of(value));
        }

        @Override
        public Demand.Builder addDeliveryLeadTime(QuantitativeValue value) {
            return (Demand.Builder)this.addProperty("http://schema.org/deliveryLeadTime", value);
        }

        @Override
        public Demand.Builder addDeliveryLeadTime(QuantitativeValue.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/deliveryLeadTime", value.build());
        }

        @Override
        public Demand.Builder addDeliveryLeadTime(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/deliveryLeadTime", Text.of(value));
        }

        @Override
        public Demand.Builder addDescription(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Demand.Builder addDescription(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Demand.Builder addEligibleCustomerType(BusinessEntityType value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleCustomerType", value);
        }

        @Override
        public Demand.Builder addEligibleCustomerType(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleCustomerType", Text.of(value));
        }

        @Override
        public Demand.Builder addEligibleDuration(QuantitativeValue value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleDuration", value);
        }

        @Override
        public Demand.Builder addEligibleDuration(QuantitativeValue.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleDuration", value.build());
        }

        @Override
        public Demand.Builder addEligibleDuration(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleDuration", Text.of(value));
        }

        @Override
        public Demand.Builder addEligibleQuantity(QuantitativeValue value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleQuantity", value);
        }

        @Override
        public Demand.Builder addEligibleQuantity(QuantitativeValue.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleQuantity", value.build());
        }

        @Override
        public Demand.Builder addEligibleQuantity(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleQuantity", Text.of(value));
        }

        @Override
        public Demand.Builder addEligibleRegion(GeoShape value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public Demand.Builder addEligibleRegion(GeoShape.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleRegion", value.build());
        }

        @Override
        public Demand.Builder addEligibleRegion(Place value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public Demand.Builder addEligibleRegion(Place.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleRegion", value.build());
        }

        @Override
        public Demand.Builder addEligibleRegion(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleRegion", value);
        }

        @Override
        public Demand.Builder addEligibleRegion(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleRegion", Text.of(value));
        }

        @Override
        public Demand.Builder addEligibleTransactionVolume(PriceSpecification value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleTransactionVolume", value);
        }

        @Override
        public Demand.Builder addEligibleTransactionVolume(PriceSpecification.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleTransactionVolume", value.build());
        }

        @Override
        public Demand.Builder addEligibleTransactionVolume(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/eligibleTransactionVolume", Text.of(value));
        }

        @Override
        public Demand.Builder addGtin12(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin12", value);
        }

        @Override
        public Demand.Builder addGtin12(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin12", Text.of(value));
        }

        @Override
        public Demand.Builder addGtin13(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin13", value);
        }

        @Override
        public Demand.Builder addGtin13(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin13", Text.of(value));
        }

        @Override
        public Demand.Builder addGtin14(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin14", value);
        }

        @Override
        public Demand.Builder addGtin14(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin14", Text.of(value));
        }

        @Override
        public Demand.Builder addGtin8(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin8", value);
        }

        @Override
        public Demand.Builder addGtin8(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/gtin8", Text.of(value));
        }

        @Override
        public Demand.Builder addImage(ImageObject value) {
            return (Demand.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Demand.Builder addImage(ImageObject.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Demand.Builder addImage(URL value) {
            return (Demand.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Demand.Builder addImage(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Demand.Builder addIncludesObject(TypeAndQuantityNode value) {
            return (Demand.Builder)this.addProperty("http://schema.org/includesObject", value);
        }

        @Override
        public Demand.Builder addIncludesObject(TypeAndQuantityNode.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/includesObject", value.build());
        }

        @Override
        public Demand.Builder addIncludesObject(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/includesObject", Text.of(value));
        }

        @Override
        public Demand.Builder addIneligibleRegion(GeoShape value) {
            return (Demand.Builder)this.addProperty("http://schema.org/ineligibleRegion", value);
        }

        @Override
        public Demand.Builder addIneligibleRegion(GeoShape.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/ineligibleRegion", value.build());
        }

        @Override
        public Demand.Builder addIneligibleRegion(Place value) {
            return (Demand.Builder)this.addProperty("http://schema.org/ineligibleRegion", value);
        }

        @Override
        public Demand.Builder addIneligibleRegion(Place.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/ineligibleRegion", value.build());
        }

        @Override
        public Demand.Builder addIneligibleRegion(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/ineligibleRegion", value);
        }

        @Override
        public Demand.Builder addIneligibleRegion(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/ineligibleRegion", Text.of(value));
        }

        @Override
        public Demand.Builder addInventoryLevel(QuantitativeValue value) {
            return (Demand.Builder)this.addProperty("http://schema.org/inventoryLevel", value);
        }

        @Override
        public Demand.Builder addInventoryLevel(QuantitativeValue.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/inventoryLevel", value.build());
        }

        @Override
        public Demand.Builder addInventoryLevel(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/inventoryLevel", Text.of(value));
        }

        @Override
        public Demand.Builder addItemCondition(OfferItemCondition value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemCondition", value);
        }

        @Override
        public Demand.Builder addItemCondition(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemCondition", Text.of(value));
        }

        @Override
        public Demand.Builder addItemOffered(Product value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemOffered", value);
        }

        @Override
        public Demand.Builder addItemOffered(Product.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemOffered", value.build());
        }

        @Override
        public Demand.Builder addItemOffered(Service value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemOffered", value);
        }

        @Override
        public Demand.Builder addItemOffered(Service.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemOffered", value.build());
        }

        @Override
        public Demand.Builder addItemOffered(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/itemOffered", Text.of(value));
        }

        @Override
        public Demand.Builder addMainEntityOfPage(CreativeWork value) {
            return (Demand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Demand.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Demand.Builder addMainEntityOfPage(URL value) {
            return (Demand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Demand.Builder addMainEntityOfPage(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Demand.Builder addMpn(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/mpn", value);
        }

        @Override
        public Demand.Builder addMpn(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/mpn", Text.of(value));
        }

        @Override
        public Demand.Builder addName(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Demand.Builder addName(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Demand.Builder addPotentialAction(Action value) {
            return (Demand.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Demand.Builder addPotentialAction(Action.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Demand.Builder addPotentialAction(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Demand.Builder addPriceSpecification(PriceSpecification value) {
            return (Demand.Builder)this.addProperty("http://schema.org/priceSpecification", value);
        }

        @Override
        public Demand.Builder addPriceSpecification(PriceSpecification.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/priceSpecification", value.build());
        }

        @Override
        public Demand.Builder addPriceSpecification(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/priceSpecification", Text.of(value));
        }

        @Override
        public Demand.Builder addSameAs(URL value) {
            return (Demand.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Demand.Builder addSameAs(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Demand.Builder addSeller(Organization value) {
            return (Demand.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Demand.Builder addSeller(Organization.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Demand.Builder addSeller(Person value) {
            return (Demand.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Demand.Builder addSeller(Person.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Demand.Builder addSeller(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/seller", Text.of(value));
        }

        @Override
        public Demand.Builder addSerialNumber(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/serialNumber", value);
        }

        @Override
        public Demand.Builder addSerialNumber(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/serialNumber", Text.of(value));
        }

        @Override
        public Demand.Builder addSku(Text value) {
            return (Demand.Builder)this.addProperty("http://schema.org/sku", value);
        }

        @Override
        public Demand.Builder addSku(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/sku", Text.of(value));
        }

        @Override
        public Demand.Builder addUrl(URL value) {
            return (Demand.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Demand.Builder addUrl(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Demand.Builder addValidFrom(DateTime value) {
            return (Demand.Builder)this.addProperty("http://schema.org/validFrom", value);
        }

        @Override
        public Demand.Builder addValidFrom(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/validFrom", Text.of(value));
        }

        @Override
        public Demand.Builder addValidThrough(DateTime value) {
            return (Demand.Builder)this.addProperty("http://schema.org/validThrough", value);
        }

        @Override
        public Demand.Builder addValidThrough(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/validThrough", Text.of(value));
        }

        @Override
        public Demand.Builder addWarranty(WarrantyPromise value) {
            return (Demand.Builder)this.addProperty("http://schema.org/warranty", value);
        }

        @Override
        public Demand.Builder addWarranty(WarrantyPromise.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.org/warranty", value.build());
        }

        @Override
        public Demand.Builder addWarranty(String value) {
            return (Demand.Builder)this.addProperty("http://schema.org/warranty", Text.of(value));
        }

        @Override
        public Demand.Builder addDetailedDescription(Article value) {
            return (Demand.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Demand.Builder addDetailedDescription(Article.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Demand.Builder addDetailedDescription(String value) {
            return (Demand.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Demand.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Demand.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Demand.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Demand.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Demand.Builder addPopularityScore(String value) {
            return (Demand.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Demand build() {
            return new DemandImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

