/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DoseSchedule;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DoseScheduleImpl
extends MedicalIntangibleImpl
implements DoseSchedule {
    private static final ImmutableSet<String> PROPERTY_SET = DoseScheduleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/doseUnit");
        builder.add((Object)"http://schema.org/doseValue");
        builder.add((Object)"http://schema.org/frequency");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/targetPopulation");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DoseScheduleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DoseSchedule";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDoseUnitList() {
        return this.getProperty("http://schema.org/doseUnit");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDoseValueList() {
        return this.getProperty("http://schema.org/doseValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFrequencyList() {
        return this.getProperty("http://schema.org/frequency");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetPopulationList() {
        return this.getProperty("http://schema.org/targetPopulation");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DoseSchedule.Builder>
    implements DoseSchedule.Builder {
        BuilderImpl() {
        }

        @Override
        public DoseSchedule.Builder addAdditionalType(URL value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DoseSchedule.Builder addAdditionalType(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addAlternateName(Text value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DoseSchedule.Builder addAlternateName(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addCode(MedicalCode value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DoseSchedule.Builder addCode(MedicalCode.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DoseSchedule.Builder addCode(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addDescription(Text value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DoseSchedule.Builder addDescription(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addDoseUnit(Text value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/doseUnit", value);
        }

        @Override
        public DoseSchedule.Builder addDoseUnit(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/doseUnit", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addDoseValue(Number value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/doseValue", value);
        }

        @Override
        public DoseSchedule.Builder addDoseValue(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/doseValue", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addFrequency(Text value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/frequency", value);
        }

        @Override
        public DoseSchedule.Builder addFrequency(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/frequency", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addGuideline(MedicalGuideline value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DoseSchedule.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DoseSchedule.Builder addGuideline(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addImage(ImageObject value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DoseSchedule.Builder addImage(ImageObject.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DoseSchedule.Builder addImage(URL value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DoseSchedule.Builder addImage(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addMainEntityOfPage(CreativeWork value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DoseSchedule.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DoseSchedule.Builder addMainEntityOfPage(URL value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DoseSchedule.Builder addMainEntityOfPage(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addMedicineSystem(MedicineSystem value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DoseSchedule.Builder addMedicineSystem(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addName(Text value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DoseSchedule.Builder addName(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addPotentialAction(Action value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DoseSchedule.Builder addPotentialAction(Action.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DoseSchedule.Builder addPotentialAction(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addRecognizingAuthority(Organization value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DoseSchedule.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DoseSchedule.Builder addRecognizingAuthority(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DoseSchedule.Builder addRelevantSpecialty(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addSameAs(URL value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DoseSchedule.Builder addSameAs(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addStudy(MedicalStudy value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DoseSchedule.Builder addStudy(MedicalStudy.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DoseSchedule.Builder addStudy(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addTargetPopulation(Text value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/targetPopulation", value);
        }

        @Override
        public DoseSchedule.Builder addTargetPopulation(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/targetPopulation", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addUrl(URL value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DoseSchedule.Builder addUrl(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addDetailedDescription(Article value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DoseSchedule.Builder addDetailedDescription(Article.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DoseSchedule.Builder addDetailedDescription(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DoseSchedule.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DoseSchedule.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DoseSchedule.Builder addPopularityScore(String value) {
            return (DoseSchedule.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DoseSchedule build() {
            return new DoseScheduleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

