/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.EntryPoint;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.SoftwareApplication;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EntryPointImpl
extends IntangibleImpl
implements EntryPoint {
    private static final ImmutableSet<String> PROPERTY_SET = EntryPointImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/actionApplication");
        builder.add((Object)"http://schema.org/actionPlatform");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/application");
        builder.add((Object)"http://schema.org/contentType");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/encodingType");
        builder.add((Object)"http://schema.org/httpMethod");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/urlTemplate");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EntryPointImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/EntryPoint";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActionApplicationList() {
        return this.getProperty("http://schema.org/actionApplication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getActionPlatformList() {
        return this.getProperty("http://schema.org/actionPlatform");
    }

    @Override
    public ImmutableList<SchemaOrgType> getApplicationList() {
        return this.getProperty("http://schema.org/application");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContentTypeList() {
        return this.getProperty("http://schema.org/contentType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEncodingTypeList() {
        return this.getProperty("http://schema.org/encodingType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHttpMethodList() {
        return this.getProperty("http://schema.org/httpMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInLanguageList() {
        return this.getProperty("http://schema.org/inLanguage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUrlTemplateList() {
        return this.getProperty("http://schema.org/urlTemplate");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<EntryPoint.Builder>
    implements EntryPoint.Builder {
        BuilderImpl() {
        }

        @Override
        public EntryPoint.Builder addActionApplication(SoftwareApplication value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/actionApplication", value);
        }

        @Override
        public EntryPoint.Builder addActionApplication(SoftwareApplication.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/actionApplication", value.build());
        }

        @Override
        public EntryPoint.Builder addActionApplication(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/actionApplication", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addActionPlatform(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/actionPlatform", value);
        }

        @Override
        public EntryPoint.Builder addActionPlatform(URL value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/actionPlatform", value);
        }

        @Override
        public EntryPoint.Builder addActionPlatform(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/actionPlatform", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addAdditionalType(URL value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public EntryPoint.Builder addAdditionalType(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addAlternateName(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public EntryPoint.Builder addAlternateName(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addApplication(SoftwareApplication value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/application", value);
        }

        @Override
        public EntryPoint.Builder addApplication(SoftwareApplication.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/application", value.build());
        }

        @Override
        public EntryPoint.Builder addApplication(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/application", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addContentType(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/contentType", value);
        }

        @Override
        public EntryPoint.Builder addContentType(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/contentType", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addDescription(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public EntryPoint.Builder addDescription(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addEncodingType(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/encodingType", value);
        }

        @Override
        public EntryPoint.Builder addEncodingType(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/encodingType", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addHttpMethod(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/httpMethod", value);
        }

        @Override
        public EntryPoint.Builder addHttpMethod(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/httpMethod", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addImage(ImageObject value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EntryPoint.Builder addImage(ImageObject.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public EntryPoint.Builder addImage(URL value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public EntryPoint.Builder addImage(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addInLanguage(Language value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public EntryPoint.Builder addInLanguage(Language.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public EntryPoint.Builder addInLanguage(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public EntryPoint.Builder addInLanguage(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addMainEntityOfPage(CreativeWork value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EntryPoint.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public EntryPoint.Builder addMainEntityOfPage(URL value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public EntryPoint.Builder addMainEntityOfPage(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addName(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public EntryPoint.Builder addName(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addPotentialAction(Action value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public EntryPoint.Builder addPotentialAction(Action.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public EntryPoint.Builder addPotentialAction(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addSameAs(URL value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public EntryPoint.Builder addSameAs(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addUrl(URL value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public EntryPoint.Builder addUrl(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addUrlTemplate(Text value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/urlTemplate", value);
        }

        @Override
        public EntryPoint.Builder addUrlTemplate(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.org/urlTemplate", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addDetailedDescription(Article value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public EntryPoint.Builder addDetailedDescription(Article.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public EntryPoint.Builder addDetailedDescription(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public EntryPoint.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public EntryPoint.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public EntryPoint.Builder addPopularityScore(String value) {
            return (EntryPoint.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public EntryPoint build() {
            return new EntryPointImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

