/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Brand;
import com.google.schemaorg.core.ContactPoint;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Demand;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.FoodEstablishment;
import com.google.schemaorg.core.GeoCoordinates;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.LocalBusinessImpl;
import com.google.schemaorg.core.Map;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.OfferCatalog;
import com.google.schemaorg.core.OpeningHoursSpecification;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.OwnershipInfo;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Photograph;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.ProgramMembership;
import com.google.schemaorg.core.PropertyValue;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class FoodEstablishmentImpl
extends LocalBusinessImpl
implements FoodEstablishment {
    private static final ImmutableSet<String> PROPERTY_SET = FoodEstablishmentImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/acceptsReservations");
        builder.add((Object)"http://schema.org/additionalProperty");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/address");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alumni");
        builder.add((Object)"http://schema.org/areaServed");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/branchCode");
        builder.add((Object)"http://schema.org/branchOf");
        builder.add((Object)"http://schema.org/brand");
        builder.add((Object)"http://schema.org/contactPoint");
        builder.add((Object)"http://schema.org/contactPoints");
        builder.add((Object)"http://schema.org/containedIn");
        builder.add((Object)"http://schema.org/containedInPlace");
        builder.add((Object)"http://schema.org/containsPlace");
        builder.add((Object)"http://schema.org/currenciesAccepted");
        builder.add((Object)"http://schema.org/department");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/dissolutionDate");
        builder.add((Object)"http://schema.org/duns");
        builder.add((Object)"http://schema.org/email");
        builder.add((Object)"http://schema.org/employee");
        builder.add((Object)"http://schema.org/employees");
        builder.add((Object)"http://schema.org/event");
        builder.add((Object)"http://schema.org/events");
        builder.add((Object)"http://schema.org/faxNumber");
        builder.add((Object)"http://schema.org/founder");
        builder.add((Object)"http://schema.org/founders");
        builder.add((Object)"http://schema.org/foundingDate");
        builder.add((Object)"http://schema.org/foundingLocation");
        builder.add((Object)"http://schema.org/geo");
        builder.add((Object)"http://schema.org/globalLocationNumber");
        builder.add((Object)"http://schema.org/hasMap");
        builder.add((Object)"http://schema.org/hasOfferCatalog");
        builder.add((Object)"http://schema.org/hasPOS");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/isicV4");
        builder.add((Object)"http://schema.org/legalName");
        builder.add((Object)"http://schema.org/location");
        builder.add((Object)"http://schema.org/logo");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/makesOffer");
        builder.add((Object)"http://schema.org/map");
        builder.add((Object)"http://schema.org/maps");
        builder.add((Object)"http://schema.org/member");
        builder.add((Object)"http://schema.org/memberOf");
        builder.add((Object)"http://schema.org/members");
        builder.add((Object)"http://schema.org/menu");
        builder.add((Object)"http://schema.org/naics");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/numberOfEmployees");
        builder.add((Object)"http://schema.org/openingHours");
        builder.add((Object)"http://schema.org/openingHoursSpecification");
        builder.add((Object)"http://schema.org/owns");
        builder.add((Object)"http://schema.org/parentOrganization");
        builder.add((Object)"http://schema.org/paymentAccepted");
        builder.add((Object)"http://schema.org/photo");
        builder.add((Object)"http://schema.org/photos");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/priceRange");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seeks");
        builder.add((Object)"http://schema.org/servesCuisine");
        builder.add((Object)"http://schema.org/serviceArea");
        builder.add((Object)"http://schema.org/subOrganization");
        builder.add((Object)"http://schema.org/taxID");
        builder.add((Object)"http://schema.org/telephone");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/vatID");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public FoodEstablishmentImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/FoodEstablishment";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAcceptsReservationsList() {
        return this.getProperty("http://schema.org/acceptsReservations");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMenuList() {
        return this.getProperty("http://schema.org/menu");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServesCuisineList() {
        return this.getProperty("http://schema.org/servesCuisine");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<FoodEstablishment.Builder>
    implements FoodEstablishment.Builder {
        BuilderImpl() {
        }

        @Override
        public FoodEstablishment.Builder addAcceptsReservations(Boolean value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/acceptsReservations", value);
        }

        @Override
        public FoodEstablishment.Builder addAcceptsReservations(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/acceptsReservations", value);
        }

        @Override
        public FoodEstablishment.Builder addAcceptsReservations(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/acceptsReservations", value);
        }

        @Override
        public FoodEstablishment.Builder addAcceptsReservations(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/acceptsReservations", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAdditionalProperty(PropertyValue value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/additionalProperty", value);
        }

        @Override
        public FoodEstablishment.Builder addAdditionalProperty(PropertyValue.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/additionalProperty", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAdditionalProperty(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/additionalProperty", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAdditionalType(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public FoodEstablishment.Builder addAdditionalType(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAddress(PostalAddress value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/address", value);
        }

        @Override
        public FoodEstablishment.Builder addAddress(PostalAddress.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/address", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAddress(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/address", value);
        }

        @Override
        public FoodEstablishment.Builder addAddress(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/address", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAggregateRating(AggregateRating value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public FoodEstablishment.Builder addAggregateRating(AggregateRating.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAggregateRating(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAlternateName(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public FoodEstablishment.Builder addAlternateName(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAlumni(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/alumni", value);
        }

        @Override
        public FoodEstablishment.Builder addAlumni(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/alumni", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAlumni(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/alumni", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(AdministrativeArea value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(AdministrativeArea.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(GeoShape value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(GeoShape.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public FoodEstablishment.Builder addAreaServed(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/areaServed", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAward(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public FoodEstablishment.Builder addAward(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addAwards(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public FoodEstablishment.Builder addAwards(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addBranchCode(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/branchCode", value);
        }

        @Override
        public FoodEstablishment.Builder addBranchCode(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/branchCode", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addBranchOf(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/branchOf", value);
        }

        @Override
        public FoodEstablishment.Builder addBranchOf(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/branchOf", value.build());
        }

        @Override
        public FoodEstablishment.Builder addBranchOf(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/branchOf", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addBrand(Brand value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/brand", value);
        }

        @Override
        public FoodEstablishment.Builder addBrand(Brand.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/brand", value.build());
        }

        @Override
        public FoodEstablishment.Builder addBrand(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/brand", value);
        }

        @Override
        public FoodEstablishment.Builder addBrand(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/brand", value.build());
        }

        @Override
        public FoodEstablishment.Builder addBrand(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/brand", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addContactPoint(ContactPoint value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/contactPoint", value);
        }

        @Override
        public FoodEstablishment.Builder addContactPoint(ContactPoint.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/contactPoint", value.build());
        }

        @Override
        public FoodEstablishment.Builder addContactPoint(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/contactPoint", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addContactPoints(ContactPoint value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/contactPoints", value);
        }

        @Override
        public FoodEstablishment.Builder addContactPoints(ContactPoint.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/contactPoints", value.build());
        }

        @Override
        public FoodEstablishment.Builder addContactPoints(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/contactPoints", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addContainedIn(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containedIn", value);
        }

        @Override
        public FoodEstablishment.Builder addContainedIn(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containedIn", value.build());
        }

        @Override
        public FoodEstablishment.Builder addContainedIn(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containedIn", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addContainedInPlace(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containedInPlace", value);
        }

        @Override
        public FoodEstablishment.Builder addContainedInPlace(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containedInPlace", value.build());
        }

        @Override
        public FoodEstablishment.Builder addContainedInPlace(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containedInPlace", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addContainsPlace(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containsPlace", value);
        }

        @Override
        public FoodEstablishment.Builder addContainsPlace(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containsPlace", value.build());
        }

        @Override
        public FoodEstablishment.Builder addContainsPlace(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/containsPlace", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addCurrenciesAccepted(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/currenciesAccepted", value);
        }

        @Override
        public FoodEstablishment.Builder addCurrenciesAccepted(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/currenciesAccepted", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addDepartment(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/department", value);
        }

        @Override
        public FoodEstablishment.Builder addDepartment(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/department", value.build());
        }

        @Override
        public FoodEstablishment.Builder addDepartment(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/department", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addDescription(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public FoodEstablishment.Builder addDescription(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addDissolutionDate(Date value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/dissolutionDate", value);
        }

        @Override
        public FoodEstablishment.Builder addDissolutionDate(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/dissolutionDate", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addDuns(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/duns", value);
        }

        @Override
        public FoodEstablishment.Builder addDuns(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/duns", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addEmail(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/email", value);
        }

        @Override
        public FoodEstablishment.Builder addEmail(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/email", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addEmployee(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/employee", value);
        }

        @Override
        public FoodEstablishment.Builder addEmployee(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/employee", value.build());
        }

        @Override
        public FoodEstablishment.Builder addEmployee(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/employee", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addEmployees(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/employees", value);
        }

        @Override
        public FoodEstablishment.Builder addEmployees(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/employees", value.build());
        }

        @Override
        public FoodEstablishment.Builder addEmployees(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/employees", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addEvent(Event value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/event", value);
        }

        @Override
        public FoodEstablishment.Builder addEvent(Event.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/event", value.build());
        }

        @Override
        public FoodEstablishment.Builder addEvent(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/event", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addEvents(Event value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/events", value);
        }

        @Override
        public FoodEstablishment.Builder addEvents(Event.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/events", value.build());
        }

        @Override
        public FoodEstablishment.Builder addEvents(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/events", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addFaxNumber(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/faxNumber", value);
        }

        @Override
        public FoodEstablishment.Builder addFaxNumber(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/faxNumber", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addFounder(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/founder", value);
        }

        @Override
        public FoodEstablishment.Builder addFounder(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/founder", value.build());
        }

        @Override
        public FoodEstablishment.Builder addFounder(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/founder", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addFounders(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/founders", value);
        }

        @Override
        public FoodEstablishment.Builder addFounders(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/founders", value.build());
        }

        @Override
        public FoodEstablishment.Builder addFounders(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/founders", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addFoundingDate(Date value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/foundingDate", value);
        }

        @Override
        public FoodEstablishment.Builder addFoundingDate(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/foundingDate", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addFoundingLocation(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/foundingLocation", value);
        }

        @Override
        public FoodEstablishment.Builder addFoundingLocation(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/foundingLocation", value.build());
        }

        @Override
        public FoodEstablishment.Builder addFoundingLocation(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/foundingLocation", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addGeo(GeoCoordinates value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/geo", value);
        }

        @Override
        public FoodEstablishment.Builder addGeo(GeoCoordinates.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/geo", value.build());
        }

        @Override
        public FoodEstablishment.Builder addGeo(GeoShape value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/geo", value);
        }

        @Override
        public FoodEstablishment.Builder addGeo(GeoShape.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/geo", value.build());
        }

        @Override
        public FoodEstablishment.Builder addGeo(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/geo", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addGlobalLocationNumber(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/globalLocationNumber", value);
        }

        @Override
        public FoodEstablishment.Builder addGlobalLocationNumber(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/globalLocationNumber", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addHasMap(Map value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasMap", value);
        }

        @Override
        public FoodEstablishment.Builder addHasMap(Map.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasMap", value.build());
        }

        @Override
        public FoodEstablishment.Builder addHasMap(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasMap", value);
        }

        @Override
        public FoodEstablishment.Builder addHasMap(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasMap", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addHasOfferCatalog(OfferCatalog value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasOfferCatalog", value);
        }

        @Override
        public FoodEstablishment.Builder addHasOfferCatalog(OfferCatalog.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasOfferCatalog", value.build());
        }

        @Override
        public FoodEstablishment.Builder addHasOfferCatalog(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasOfferCatalog", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addHasPOS(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasPOS", value);
        }

        @Override
        public FoodEstablishment.Builder addHasPOS(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasPOS", value.build());
        }

        @Override
        public FoodEstablishment.Builder addHasPOS(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/hasPOS", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addImage(ImageObject value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public FoodEstablishment.Builder addImage(ImageObject.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public FoodEstablishment.Builder addImage(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public FoodEstablishment.Builder addImage(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addIsicV4(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/isicV4", value);
        }

        @Override
        public FoodEstablishment.Builder addIsicV4(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/isicV4", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addLegalName(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/legalName", value);
        }

        @Override
        public FoodEstablishment.Builder addLegalName(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/legalName", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addLocation(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public FoodEstablishment.Builder addLocation(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public FoodEstablishment.Builder addLocation(PostalAddress value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public FoodEstablishment.Builder addLocation(PostalAddress.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public FoodEstablishment.Builder addLocation(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public FoodEstablishment.Builder addLocation(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/location", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addLogo(ImageObject value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/logo", value);
        }

        @Override
        public FoodEstablishment.Builder addLogo(ImageObject.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/logo", value.build());
        }

        @Override
        public FoodEstablishment.Builder addLogo(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/logo", value);
        }

        @Override
        public FoodEstablishment.Builder addLogo(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/logo", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMainEntityOfPage(CreativeWork value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public FoodEstablishment.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMainEntityOfPage(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public FoodEstablishment.Builder addMainEntityOfPage(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMakesOffer(Offer value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/makesOffer", value);
        }

        @Override
        public FoodEstablishment.Builder addMakesOffer(Offer.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/makesOffer", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMakesOffer(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/makesOffer", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMap(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/map", value);
        }

        @Override
        public FoodEstablishment.Builder addMap(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/map", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMaps(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/maps", value);
        }

        @Override
        public FoodEstablishment.Builder addMaps(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/maps", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMember(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/member", value);
        }

        @Override
        public FoodEstablishment.Builder addMember(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/member", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMember(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/member", value);
        }

        @Override
        public FoodEstablishment.Builder addMember(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/member", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMember(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/member", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMemberOf(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/memberOf", value);
        }

        @Override
        public FoodEstablishment.Builder addMemberOf(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/memberOf", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMemberOf(ProgramMembership value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/memberOf", value);
        }

        @Override
        public FoodEstablishment.Builder addMemberOf(ProgramMembership.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/memberOf", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMemberOf(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/memberOf", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMembers(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/members", value);
        }

        @Override
        public FoodEstablishment.Builder addMembers(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/members", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMembers(Person value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/members", value);
        }

        @Override
        public FoodEstablishment.Builder addMembers(Person.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/members", value.build());
        }

        @Override
        public FoodEstablishment.Builder addMembers(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/members", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addMenu(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/menu", value);
        }

        @Override
        public FoodEstablishment.Builder addMenu(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/menu", value);
        }

        @Override
        public FoodEstablishment.Builder addMenu(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/menu", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addNaics(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/naics", value);
        }

        @Override
        public FoodEstablishment.Builder addNaics(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/naics", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addName(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public FoodEstablishment.Builder addName(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addNumberOfEmployees(QuantitativeValue value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/numberOfEmployees", value);
        }

        @Override
        public FoodEstablishment.Builder addNumberOfEmployees(QuantitativeValue.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/numberOfEmployees", value.build());
        }

        @Override
        public FoodEstablishment.Builder addNumberOfEmployees(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/numberOfEmployees", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addOpeningHours(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/openingHours", value);
        }

        @Override
        public FoodEstablishment.Builder addOpeningHours(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/openingHours", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addOpeningHoursSpecification(OpeningHoursSpecification value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/openingHoursSpecification", value);
        }

        @Override
        public FoodEstablishment.Builder addOpeningHoursSpecification(OpeningHoursSpecification.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/openingHoursSpecification", value.build());
        }

        @Override
        public FoodEstablishment.Builder addOpeningHoursSpecification(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/openingHoursSpecification", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addOwns(OwnershipInfo value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/owns", value);
        }

        @Override
        public FoodEstablishment.Builder addOwns(OwnershipInfo.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/owns", value.build());
        }

        @Override
        public FoodEstablishment.Builder addOwns(Product value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/owns", value);
        }

        @Override
        public FoodEstablishment.Builder addOwns(Product.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/owns", value.build());
        }

        @Override
        public FoodEstablishment.Builder addOwns(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/owns", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addParentOrganization(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/parentOrganization", value);
        }

        @Override
        public FoodEstablishment.Builder addParentOrganization(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/parentOrganization", value.build());
        }

        @Override
        public FoodEstablishment.Builder addParentOrganization(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/parentOrganization", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addPaymentAccepted(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/paymentAccepted", value);
        }

        @Override
        public FoodEstablishment.Builder addPaymentAccepted(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/paymentAccepted", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addPhoto(ImageObject value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photo", value);
        }

        @Override
        public FoodEstablishment.Builder addPhoto(ImageObject.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photo", value.build());
        }

        @Override
        public FoodEstablishment.Builder addPhoto(Photograph value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photo", value);
        }

        @Override
        public FoodEstablishment.Builder addPhoto(Photograph.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photo", value.build());
        }

        @Override
        public FoodEstablishment.Builder addPhoto(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photo", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addPhotos(ImageObject value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photos", value);
        }

        @Override
        public FoodEstablishment.Builder addPhotos(ImageObject.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photos", value.build());
        }

        @Override
        public FoodEstablishment.Builder addPhotos(Photograph value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photos", value);
        }

        @Override
        public FoodEstablishment.Builder addPhotos(Photograph.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photos", value.build());
        }

        @Override
        public FoodEstablishment.Builder addPhotos(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/photos", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addPotentialAction(Action value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public FoodEstablishment.Builder addPotentialAction(Action.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public FoodEstablishment.Builder addPotentialAction(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addPriceRange(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/priceRange", value);
        }

        @Override
        public FoodEstablishment.Builder addPriceRange(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/priceRange", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addReview(Review value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public FoodEstablishment.Builder addReview(Review.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public FoodEstablishment.Builder addReview(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addReviews(Review value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public FoodEstablishment.Builder addReviews(Review.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public FoodEstablishment.Builder addReviews(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addSameAs(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public FoodEstablishment.Builder addSameAs(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addSeeks(Demand value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/seeks", value);
        }

        @Override
        public FoodEstablishment.Builder addSeeks(Demand.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/seeks", value.build());
        }

        @Override
        public FoodEstablishment.Builder addSeeks(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/seeks", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addServesCuisine(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/servesCuisine", value);
        }

        @Override
        public FoodEstablishment.Builder addServesCuisine(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/servesCuisine", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(AdministrativeArea value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(AdministrativeArea.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(GeoShape value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(GeoShape.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(Place value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(Place.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public FoodEstablishment.Builder addServiceArea(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/serviceArea", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addSubOrganization(Organization value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/subOrganization", value);
        }

        @Override
        public FoodEstablishment.Builder addSubOrganization(Organization.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/subOrganization", value.build());
        }

        @Override
        public FoodEstablishment.Builder addSubOrganization(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/subOrganization", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addTaxID(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/taxID", value);
        }

        @Override
        public FoodEstablishment.Builder addTaxID(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/taxID", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addTelephone(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/telephone", value);
        }

        @Override
        public FoodEstablishment.Builder addTelephone(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/telephone", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addUrl(URL value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public FoodEstablishment.Builder addUrl(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addVatID(Text value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/vatID", value);
        }

        @Override
        public FoodEstablishment.Builder addVatID(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.org/vatID", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addDetailedDescription(Article value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public FoodEstablishment.Builder addDetailedDescription(Article.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public FoodEstablishment.Builder addDetailedDescription(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public FoodEstablishment.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public FoodEstablishment.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public FoodEstablishment.Builder addPopularityScore(String value) {
            return (FoodEstablishment.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public FoodEstablishment build() {
            return new FoodEstablishmentImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

