/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.SoftwareApplication;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.WebSite;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class InteractionCounterImpl
extends StructuredValueImpl
implements InteractionCounter {
    private static final ImmutableSet<String> PROPERTY_SET = InteractionCounterImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/interactionService");
        builder.add((Object)"http://schema.org/interactionType");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/userInteractionCount");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public InteractionCounterImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/InteractionCounter";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getInteractionServiceList() {
        return this.getProperty("http://schema.org/interactionService");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInteractionTypeList() {
        return this.getProperty("http://schema.org/interactionType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUserInteractionCountList() {
        return this.getProperty("http://schema.org/userInteractionCount");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<InteractionCounter.Builder>
    implements InteractionCounter.Builder {
        BuilderImpl() {
        }

        @Override
        public InteractionCounter.Builder addAdditionalType(URL value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public InteractionCounter.Builder addAdditionalType(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addAlternateName(Text value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public InteractionCounter.Builder addAlternateName(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addDescription(Text value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public InteractionCounter.Builder addDescription(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addImage(ImageObject value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public InteractionCounter.Builder addImage(ImageObject.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public InteractionCounter.Builder addImage(URL value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public InteractionCounter.Builder addImage(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addInteractionService(SoftwareApplication value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionService", value);
        }

        @Override
        public InteractionCounter.Builder addInteractionService(SoftwareApplication.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionService", value.build());
        }

        @Override
        public InteractionCounter.Builder addInteractionService(WebSite value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionService", value);
        }

        @Override
        public InteractionCounter.Builder addInteractionService(WebSite.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionService", value.build());
        }

        @Override
        public InteractionCounter.Builder addInteractionService(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionService", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addInteractionType(Action value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionType", value);
        }

        @Override
        public InteractionCounter.Builder addInteractionType(Action.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionType", value.build());
        }

        @Override
        public InteractionCounter.Builder addInteractionType(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/interactionType", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addMainEntityOfPage(CreativeWork value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public InteractionCounter.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public InteractionCounter.Builder addMainEntityOfPage(URL value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public InteractionCounter.Builder addMainEntityOfPage(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addName(Text value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public InteractionCounter.Builder addName(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addPotentialAction(Action value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public InteractionCounter.Builder addPotentialAction(Action.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public InteractionCounter.Builder addPotentialAction(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addSameAs(URL value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public InteractionCounter.Builder addSameAs(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addUrl(URL value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public InteractionCounter.Builder addUrl(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addUserInteractionCount(Integer value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/userInteractionCount", value);
        }

        @Override
        public InteractionCounter.Builder addUserInteractionCount(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.org/userInteractionCount", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addDetailedDescription(Article value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public InteractionCounter.Builder addDetailedDescription(Article.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public InteractionCounter.Builder addDetailedDescription(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public InteractionCounter.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public InteractionCounter.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public InteractionCounter.Builder addPopularityScore(String value) {
            return (InteractionCounter.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public InteractionCounter build() {
            return new InteractionCounterImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

