/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalStructureImpl;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Joint;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class JointImpl
extends AnatomicalStructureImpl
implements Joint {
    private static final ImmutableSet<String> PROPERTY_SET = JointImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/biomechnicalClass");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/functionalClass");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/structuralClass");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public JointImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Joint";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBiomechnicalClassList() {
        return this.getProperty("http://schema.org/biomechnicalClass");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFunctionalClassList() {
        return this.getProperty("http://schema.org/functionalClass");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStructuralClassList() {
        return this.getProperty("http://schema.org/structuralClass");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Joint.Builder>
    implements Joint.Builder {
        BuilderImpl() {
        }

        @Override
        public Joint.Builder addAdditionalType(URL value) {
            return (Joint.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Joint.Builder addAdditionalType(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Joint.Builder addAlternateName(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Joint.Builder addAlternateName(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Joint.Builder addAssociatedPathophysiology(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public Joint.Builder addAssociatedPathophysiology(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public Joint.Builder addBiomechnicalClass(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/biomechnicalClass", value);
        }

        @Override
        public Joint.Builder addBiomechnicalClass(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/biomechnicalClass", Text.of(value));
        }

        @Override
        public Joint.Builder addBodyLocation(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public Joint.Builder addBodyLocation(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public Joint.Builder addCode(MedicalCode value) {
            return (Joint.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Joint.Builder addCode(MedicalCode.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Joint.Builder addCode(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Joint.Builder addConnectedTo(AnatomicalStructure value) {
            return (Joint.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public Joint.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public Joint.Builder addConnectedTo(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public Joint.Builder addDescription(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Joint.Builder addDescription(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Joint.Builder addDiagram(ImageObject value) {
            return (Joint.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public Joint.Builder addDiagram(ImageObject.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public Joint.Builder addDiagram(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public Joint.Builder addFunction(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public Joint.Builder addFunction(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public Joint.Builder addFunctionalClass(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/functionalClass", value);
        }

        @Override
        public Joint.Builder addFunctionalClass(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/functionalClass", Text.of(value));
        }

        @Override
        public Joint.Builder addGuideline(MedicalGuideline value) {
            return (Joint.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Joint.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Joint.Builder addGuideline(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Joint.Builder addImage(ImageObject value) {
            return (Joint.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Joint.Builder addImage(ImageObject.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Joint.Builder addImage(URL value) {
            return (Joint.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Joint.Builder addImage(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Joint.Builder addMainEntityOfPage(CreativeWork value) {
            return (Joint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Joint.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Joint.Builder addMainEntityOfPage(URL value) {
            return (Joint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Joint.Builder addMainEntityOfPage(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Joint.Builder addMedicineSystem(MedicineSystem value) {
            return (Joint.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Joint.Builder addMedicineSystem(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Joint.Builder addName(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Joint.Builder addName(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Joint.Builder addPartOfSystem(AnatomicalSystem value) {
            return (Joint.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public Joint.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public Joint.Builder addPartOfSystem(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public Joint.Builder addPotentialAction(Action value) {
            return (Joint.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Joint.Builder addPotentialAction(Action.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Joint.Builder addPotentialAction(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Joint.Builder addRecognizingAuthority(Organization value) {
            return (Joint.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Joint.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Joint.Builder addRecognizingAuthority(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Joint.Builder addRelatedCondition(MedicalCondition value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public Joint.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public Joint.Builder addRelatedCondition(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public Joint.Builder addRelatedTherapy(MedicalTherapy value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public Joint.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public Joint.Builder addRelatedTherapy(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public Joint.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Joint.Builder addRelevantSpecialty(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Joint.Builder addSameAs(URL value) {
            return (Joint.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Joint.Builder addSameAs(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Joint.Builder addStructuralClass(Text value) {
            return (Joint.Builder)this.addProperty("http://schema.org/structuralClass", value);
        }

        @Override
        public Joint.Builder addStructuralClass(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/structuralClass", Text.of(value));
        }

        @Override
        public Joint.Builder addStudy(MedicalStudy value) {
            return (Joint.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Joint.Builder addStudy(MedicalStudy.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Joint.Builder addStudy(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Joint.Builder addSubStructure(AnatomicalStructure value) {
            return (Joint.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public Joint.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public Joint.Builder addSubStructure(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public Joint.Builder addUrl(URL value) {
            return (Joint.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Joint.Builder addUrl(String value) {
            return (Joint.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Joint.Builder addDetailedDescription(Article value) {
            return (Joint.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Joint.Builder addDetailedDescription(Article.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Joint.Builder addDetailedDescription(String value) {
            return (Joint.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Joint.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Joint.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Joint.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Joint.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Joint.Builder addPopularityScore(String value) {
            return (Joint.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Joint build() {
            return new JointImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

