/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Distance;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.NewsArticle;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MediaObjectImpl
extends CreativeWorkImpl
implements MediaObject {
    private static final ImmutableSet<String> PROPERTY_SET = MediaObjectImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedArticle");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/bitrate");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contentSize");
        builder.add((Object)"http://schema.org/contentUrl");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/embedUrl");
        builder.add((Object)"http://schema.org/encodesCreativeWork");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodingFormat");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/expires");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/height");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/playerType");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/productionCompany");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/regionsAllowed");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/requiresSubscription");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/uploadDate");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/width");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MediaObjectImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MediaObject";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAssociatedArticleList() {
        return this.getProperty("http://schema.org/associatedArticle");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBitrateList() {
        return this.getProperty("http://schema.org/bitrate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContentSizeList() {
        return this.getProperty("http://schema.org/contentSize");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContentUrlList() {
        return this.getProperty("http://schema.org/contentUrl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDurationList() {
        return this.getProperty("http://schema.org/duration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEmbedUrlList() {
        return this.getProperty("http://schema.org/embedUrl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEncodesCreativeWorkList() {
        return this.getProperty("http://schema.org/encodesCreativeWork");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEncodingFormatList() {
        return this.getProperty("http://schema.org/encodingFormat");
    }

    @Override
    public ImmutableList<SchemaOrgType> getExpiresList() {
        return this.getProperty("http://schema.org/expires");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHeightList() {
        return this.getProperty("http://schema.org/height");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPlayerTypeList() {
        return this.getProperty("http://schema.org/playerType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProductionCompanyList() {
        return this.getProperty("http://schema.org/productionCompany");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRegionsAllowedList() {
        return this.getProperty("http://schema.org/regionsAllowed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRequiresSubscriptionList() {
        return this.getProperty("http://schema.org/requiresSubscription");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUploadDateList() {
        return this.getProperty("http://schema.org/uploadDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWidthList() {
        return this.getProperty("http://schema.org/width");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MediaObject.Builder>
    implements MediaObject.Builder {
        BuilderImpl() {
        }

        @Override
        public MediaObject.Builder addAbout(Thing value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public MediaObject.Builder addAbout(Thing.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public MediaObject.Builder addAbout(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAccessibilityAPI(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public MediaObject.Builder addAccessibilityAPI(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAccessibilityControl(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public MediaObject.Builder addAccessibilityControl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAccessibilityFeature(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public MediaObject.Builder addAccessibilityFeature(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAccessibilityHazard(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public MediaObject.Builder addAccessibilityHazard(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAccountablePerson(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public MediaObject.Builder addAccountablePerson(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public MediaObject.Builder addAccountablePerson(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAdditionalType(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MediaObject.Builder addAdditionalType(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAggregateRating(AggregateRating value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public MediaObject.Builder addAggregateRating(AggregateRating.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public MediaObject.Builder addAggregateRating(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAlternateName(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MediaObject.Builder addAlternateName(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAlternativeHeadline(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public MediaObject.Builder addAlternativeHeadline(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAssociatedArticle(NewsArticle value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/associatedArticle", value);
        }

        @Override
        public MediaObject.Builder addAssociatedArticle(NewsArticle.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/associatedArticle", value.build());
        }

        @Override
        public MediaObject.Builder addAssociatedArticle(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/associatedArticle", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAssociatedMedia(MediaObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public MediaObject.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public MediaObject.Builder addAssociatedMedia(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAudience(Audience value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public MediaObject.Builder addAudience(Audience.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public MediaObject.Builder addAudience(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAudio(AudioObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public MediaObject.Builder addAudio(AudioObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public MediaObject.Builder addAudio(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAuthor(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MediaObject.Builder addAuthor(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MediaObject.Builder addAuthor(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MediaObject.Builder addAuthor(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MediaObject.Builder addAuthor(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAward(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public MediaObject.Builder addAward(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public MediaObject.Builder addAwards(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public MediaObject.Builder addAwards(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public MediaObject.Builder addBitrate(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/bitrate", value);
        }

        @Override
        public MediaObject.Builder addBitrate(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/bitrate", Text.of(value));
        }

        @Override
        public MediaObject.Builder addCharacter(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public MediaObject.Builder addCharacter(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public MediaObject.Builder addCharacter(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public MediaObject.Builder addCitation(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MediaObject.Builder addCitation(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public MediaObject.Builder addCitation(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MediaObject.Builder addCitation(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public MediaObject.Builder addComment(Comment value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public MediaObject.Builder addComment(Comment.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public MediaObject.Builder addComment(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public MediaObject.Builder addCommentCount(Integer value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public MediaObject.Builder addCommentCount(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public MediaObject.Builder addContentLocation(Place value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public MediaObject.Builder addContentLocation(Place.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public MediaObject.Builder addContentLocation(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public MediaObject.Builder addContentRating(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public MediaObject.Builder addContentRating(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public MediaObject.Builder addContentSize(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentSize", value);
        }

        @Override
        public MediaObject.Builder addContentSize(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentSize", Text.of(value));
        }

        @Override
        public MediaObject.Builder addContentUrl(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentUrl", value);
        }

        @Override
        public MediaObject.Builder addContentUrl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contentUrl", Text.of(value));
        }

        @Override
        public MediaObject.Builder addContributor(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MediaObject.Builder addContributor(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MediaObject.Builder addContributor(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MediaObject.Builder addContributor(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MediaObject.Builder addContributor(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public MediaObject.Builder addCopyrightHolder(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MediaObject.Builder addCopyrightHolder(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MediaObject.Builder addCopyrightHolder(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MediaObject.Builder addCopyrightHolder(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MediaObject.Builder addCopyrightHolder(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public MediaObject.Builder addCopyrightYear(Number value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public MediaObject.Builder addCopyrightYear(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public MediaObject.Builder addCreator(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MediaObject.Builder addCreator(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MediaObject.Builder addCreator(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MediaObject.Builder addCreator(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MediaObject.Builder addCreator(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDateCreated(Date value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MediaObject.Builder addDateCreated(DateTime value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MediaObject.Builder addDateCreated(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDateModified(Date value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MediaObject.Builder addDateModified(DateTime value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MediaObject.Builder addDateModified(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDatePublished(Date value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public MediaObject.Builder addDatePublished(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDescription(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MediaObject.Builder addDescription(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDiscussionUrl(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public MediaObject.Builder addDiscussionUrl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDuration(Duration value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public MediaObject.Builder addDuration(Duration.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public MediaObject.Builder addDuration(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEditor(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public MediaObject.Builder addEditor(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public MediaObject.Builder addEditor(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEducationalAlignment(AlignmentObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public MediaObject.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public MediaObject.Builder addEducationalAlignment(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEducationalUse(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public MediaObject.Builder addEducationalUse(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEmbedUrl(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/embedUrl", value);
        }

        @Override
        public MediaObject.Builder addEmbedUrl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/embedUrl", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEncodesCreativeWork(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodesCreativeWork", value);
        }

        @Override
        public MediaObject.Builder addEncodesCreativeWork(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodesCreativeWork", value.build());
        }

        @Override
        public MediaObject.Builder addEncodesCreativeWork(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodesCreativeWork", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEncoding(MediaObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public MediaObject.Builder addEncoding(MediaObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public MediaObject.Builder addEncoding(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEncodingFormat(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodingFormat", value);
        }

        @Override
        public MediaObject.Builder addEncodingFormat(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodingFormat", Text.of(value));
        }

        @Override
        public MediaObject.Builder addEncodings(MediaObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public MediaObject.Builder addEncodings(MediaObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public MediaObject.Builder addEncodings(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public MediaObject.Builder addExampleOfWork(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public MediaObject.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public MediaObject.Builder addExampleOfWork(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public MediaObject.Builder addExpires(Date value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/expires", value);
        }

        @Override
        public MediaObject.Builder addExpires(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/expires", Text.of(value));
        }

        @Override
        public MediaObject.Builder addFileFormat(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public MediaObject.Builder addFileFormat(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public MediaObject.Builder addGenre(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MediaObject.Builder addGenre(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MediaObject.Builder addGenre(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public MediaObject.Builder addHasPart(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public MediaObject.Builder addHasPart(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public MediaObject.Builder addHasPart(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public MediaObject.Builder addHeadline(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public MediaObject.Builder addHeadline(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public MediaObject.Builder addHeight(Distance value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public MediaObject.Builder addHeight(Distance.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public MediaObject.Builder addHeight(QuantitativeValue value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public MediaObject.Builder addHeight(QuantitativeValue.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public MediaObject.Builder addHeight(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/height", Text.of(value));
        }

        @Override
        public MediaObject.Builder addImage(ImageObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MediaObject.Builder addImage(ImageObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MediaObject.Builder addImage(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MediaObject.Builder addImage(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MediaObject.Builder addInLanguage(Language value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MediaObject.Builder addInLanguage(Language.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public MediaObject.Builder addInLanguage(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MediaObject.Builder addInLanguage(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public MediaObject.Builder addInteractionStatistic(InteractionCounter value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public MediaObject.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public MediaObject.Builder addInteractionStatistic(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public MediaObject.Builder addInteractivityType(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public MediaObject.Builder addInteractivityType(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public MediaObject.Builder addIsBasedOnUrl(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public MediaObject.Builder addIsBasedOnUrl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public MediaObject.Builder addIsFamilyFriendly(Boolean value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public MediaObject.Builder addIsFamilyFriendly(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public MediaObject.Builder addIsPartOf(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public MediaObject.Builder addIsPartOf(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public MediaObject.Builder addIsPartOf(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public MediaObject.Builder addKeywords(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public MediaObject.Builder addKeywords(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public MediaObject.Builder addLearningResourceType(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public MediaObject.Builder addLearningResourceType(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public MediaObject.Builder addLicense(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MediaObject.Builder addLicense(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public MediaObject.Builder addLicense(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MediaObject.Builder addLicense(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public MediaObject.Builder addLocationCreated(Place value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public MediaObject.Builder addLocationCreated(Place.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public MediaObject.Builder addLocationCreated(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public MediaObject.Builder addMainEntity(Thing value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public MediaObject.Builder addMainEntity(Thing.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public MediaObject.Builder addMainEntity(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public MediaObject.Builder addMainEntityOfPage(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MediaObject.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MediaObject.Builder addMainEntityOfPage(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MediaObject.Builder addMainEntityOfPage(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MediaObject.Builder addMentions(Thing value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public MediaObject.Builder addMentions(Thing.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public MediaObject.Builder addMentions(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public MediaObject.Builder addName(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MediaObject.Builder addName(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MediaObject.Builder addOffers(Offer value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public MediaObject.Builder addOffers(Offer.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public MediaObject.Builder addOffers(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPlayerType(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/playerType", value);
        }

        @Override
        public MediaObject.Builder addPlayerType(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/playerType", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPosition(Integer value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MediaObject.Builder addPosition(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MediaObject.Builder addPosition(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPotentialAction(Action value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MediaObject.Builder addPotentialAction(Action.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MediaObject.Builder addPotentialAction(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MediaObject.Builder addProducer(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MediaObject.Builder addProducer(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MediaObject.Builder addProducer(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MediaObject.Builder addProducer(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MediaObject.Builder addProducer(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public MediaObject.Builder addProductionCompany(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/productionCompany", value);
        }

        @Override
        public MediaObject.Builder addProductionCompany(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/productionCompany", value.build());
        }

        @Override
        public MediaObject.Builder addProductionCompany(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/productionCompany", Text.of(value));
        }

        @Override
        public MediaObject.Builder addProvider(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MediaObject.Builder addProvider(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MediaObject.Builder addProvider(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MediaObject.Builder addProvider(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MediaObject.Builder addProvider(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPublication(PublicationEvent value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public MediaObject.Builder addPublication(PublicationEvent.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public MediaObject.Builder addPublication(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPublisher(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MediaObject.Builder addPublisher(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MediaObject.Builder addPublisher(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MediaObject.Builder addPublisher(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MediaObject.Builder addPublisher(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPublishingPrinciples(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public MediaObject.Builder addPublishingPrinciples(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public MediaObject.Builder addRecordedAt(Event value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public MediaObject.Builder addRecordedAt(Event.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public MediaObject.Builder addRecordedAt(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public MediaObject.Builder addRegionsAllowed(Place value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/regionsAllowed", value);
        }

        @Override
        public MediaObject.Builder addRegionsAllowed(Place.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/regionsAllowed", value.build());
        }

        @Override
        public MediaObject.Builder addRegionsAllowed(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/regionsAllowed", Text.of(value));
        }

        @Override
        public MediaObject.Builder addReleasedEvent(PublicationEvent value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public MediaObject.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public MediaObject.Builder addReleasedEvent(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public MediaObject.Builder addRequiresSubscription(Boolean value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/requiresSubscription", value);
        }

        @Override
        public MediaObject.Builder addRequiresSubscription(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/requiresSubscription", Text.of(value));
        }

        @Override
        public MediaObject.Builder addReview(Review value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public MediaObject.Builder addReview(Review.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public MediaObject.Builder addReview(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public MediaObject.Builder addReviews(Review value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public MediaObject.Builder addReviews(Review.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public MediaObject.Builder addReviews(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public MediaObject.Builder addSameAs(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MediaObject.Builder addSameAs(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MediaObject.Builder addSchemaVersion(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MediaObject.Builder addSchemaVersion(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MediaObject.Builder addSchemaVersion(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public MediaObject.Builder addSourceOrganization(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public MediaObject.Builder addSourceOrganization(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public MediaObject.Builder addSourceOrganization(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public MediaObject.Builder addText(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public MediaObject.Builder addText(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public MediaObject.Builder addThumbnailUrl(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public MediaObject.Builder addThumbnailUrl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public MediaObject.Builder addTimeRequired(Duration value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public MediaObject.Builder addTimeRequired(Duration.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public MediaObject.Builder addTimeRequired(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public MediaObject.Builder addTranslator(Organization value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MediaObject.Builder addTranslator(Organization.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MediaObject.Builder addTranslator(Person value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MediaObject.Builder addTranslator(Person.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MediaObject.Builder addTranslator(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public MediaObject.Builder addTypicalAgeRange(Text value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public MediaObject.Builder addTypicalAgeRange(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public MediaObject.Builder addUploadDate(Date value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/uploadDate", value);
        }

        @Override
        public MediaObject.Builder addUploadDate(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/uploadDate", Text.of(value));
        }

        @Override
        public MediaObject.Builder addUrl(URL value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MediaObject.Builder addUrl(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MediaObject.Builder addVersion(Number value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public MediaObject.Builder addVersion(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public MediaObject.Builder addVideo(VideoObject value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public MediaObject.Builder addVideo(VideoObject.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public MediaObject.Builder addVideo(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public MediaObject.Builder addWidth(Distance value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public MediaObject.Builder addWidth(Distance.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public MediaObject.Builder addWidth(QuantitativeValue value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public MediaObject.Builder addWidth(QuantitativeValue.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public MediaObject.Builder addWidth(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/width", Text.of(value));
        }

        @Override
        public MediaObject.Builder addWorkExample(CreativeWork value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public MediaObject.Builder addWorkExample(CreativeWork.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public MediaObject.Builder addWorkExample(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public MediaObject.Builder addDetailedDescription(Article value) {
            return (MediaObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MediaObject.Builder addDetailedDescription(Article.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MediaObject.Builder addDetailedDescription(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MediaObject.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MediaObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MediaObject.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MediaObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MediaObject.Builder addPopularityScore(String value) {
            return (MediaObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MediaObject build() {
            return new MediaObjectImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

