/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalObservationalStudy;
import com.google.schemaorg.core.MedicalObservationalStudyDesign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalStudyImpl;
import com.google.schemaorg.core.MedicalStudyStatus;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalObservationalStudyImpl
extends MedicalStudyImpl
implements MedicalObservationalStudy {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalObservationalStudyImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/outcome");
        builder.add((Object)"http://schema.org/population");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/sponsor");
        builder.add((Object)"http://schema.org/status");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/studyDesign");
        builder.add((Object)"http://schema.org/studyLocation");
        builder.add((Object)"http://schema.org/studySubject");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalObservationalStudyImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalObservationalStudy";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getStudyDesignList() {
        return this.getProperty("http://schema.org/studyDesign");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalObservationalStudy.Builder>
    implements MedicalObservationalStudy.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalObservationalStudy.Builder addAdditionalType(URL value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addAdditionalType(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addAlternateName(Text value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addAlternateName(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addCode(MedicalCode value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addCode(MedicalCode.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addCode(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addDescription(Text value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addDescription(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addGuideline(MedicalGuideline value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addGuideline(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addImage(ImageObject value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addImage(ImageObject.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addImage(URL value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addImage(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addMainEntityOfPage(URL value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addMainEntityOfPage(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addMedicineSystem(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addName(Text value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addName(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addOutcome(Text value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/outcome", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addOutcome(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/outcome", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addPopulation(Text value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/population", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addPopulation(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/population", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addPotentialAction(Action value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addPotentialAction(Action.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addPotentialAction(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addRecognizingAuthority(Organization value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addRecognizingAuthority(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addRelevantSpecialty(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addSameAs(URL value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addSameAs(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addSponsor(Organization value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/sponsor", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addSponsor(Organization.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/sponsor", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addSponsor(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/sponsor", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addStatus(MedicalStudyStatus value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/status", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addStatus(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/status", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addStudy(MedicalStudy value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addStudy(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addStudyDesign(MedicalObservationalStudyDesign value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studyDesign", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addStudyDesign(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studyDesign", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addStudyLocation(AdministrativeArea value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studyLocation", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addStudyLocation(AdministrativeArea.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studyLocation", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addStudyLocation(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studyLocation", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addStudySubject(MedicalEntity value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studySubject", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addStudySubject(MedicalEntity.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studySubject", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addStudySubject(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/studySubject", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addUrl(URL value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addUrl(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addDetailedDescription(Article value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addDetailedDescription(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalObservationalStudy.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalObservationalStudy.Builder addPopularityScore(String value) {
            return (MedicalObservationalStudy.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalObservationalStudy build() {
            return new MedicalObservationalStudyImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

