/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCause;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSignOrSymptomImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalSymptom;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalSymptomImpl
extends MedicalSignOrSymptomImpl
implements MedicalSymptom {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalSymptomImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/cause");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/possibleTreatment");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalSymptomImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalSymptom";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalSymptom.Builder>
    implements MedicalSymptom.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalSymptom.Builder addAdditionalType(URL value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalSymptom.Builder addAdditionalType(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addAlternateName(Text value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalSymptom.Builder addAlternateName(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addCause(MedicalCause value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/cause", value);
        }

        @Override
        public MedicalSymptom.Builder addCause(MedicalCause.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/cause", value.build());
        }

        @Override
        public MedicalSymptom.Builder addCause(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/cause", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addCode(MedicalCode value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalSymptom.Builder addCode(MedicalCode.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalSymptom.Builder addCode(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addDescription(Text value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalSymptom.Builder addDescription(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addGuideline(MedicalGuideline value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalSymptom.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalSymptom.Builder addGuideline(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addImage(ImageObject value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalSymptom.Builder addImage(ImageObject.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalSymptom.Builder addImage(URL value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalSymptom.Builder addImage(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalSymptom.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalSymptom.Builder addMainEntityOfPage(URL value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalSymptom.Builder addMainEntityOfPage(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalSymptom.Builder addMedicineSystem(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addName(Text value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalSymptom.Builder addName(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addPossibleTreatment(MedicalTherapy value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/possibleTreatment", value);
        }

        @Override
        public MedicalSymptom.Builder addPossibleTreatment(MedicalTherapy.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/possibleTreatment", value.build());
        }

        @Override
        public MedicalSymptom.Builder addPossibleTreatment(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/possibleTreatment", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addPotentialAction(Action value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalSymptom.Builder addPotentialAction(Action.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalSymptom.Builder addPotentialAction(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addRecognizingAuthority(Organization value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalSymptom.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalSymptom.Builder addRecognizingAuthority(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalSymptom.Builder addRelevantSpecialty(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addSameAs(URL value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalSymptom.Builder addSameAs(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addStudy(MedicalStudy value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalSymptom.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalSymptom.Builder addStudy(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addUrl(URL value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalSymptom.Builder addUrl(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addDetailedDescription(Article value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalSymptom.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalSymptom.Builder addDetailedDescription(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalSymptom.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalSymptom.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalSymptom.Builder addPopularityScore(String value) {
            return (MedicalSymptom.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalSymptom build() {
            return new MedicalSymptomImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

