/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Energy;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Mass;
import com.google.schemaorg.core.NutritionInformation;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class NutritionInformationImpl
extends StructuredValueImpl
implements NutritionInformation {
    private static final ImmutableSet<String> PROPERTY_SET = NutritionInformationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/calories");
        builder.add((Object)"http://schema.org/carbohydrateContent");
        builder.add((Object)"http://schema.org/cholesterolContent");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/fatContent");
        builder.add((Object)"http://schema.org/fiberContent");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/proteinContent");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/saturatedFatContent");
        builder.add((Object)"http://schema.org/servingSize");
        builder.add((Object)"http://schema.org/sodiumContent");
        builder.add((Object)"http://schema.org/sugarContent");
        builder.add((Object)"http://schema.org/transFatContent");
        builder.add((Object)"http://schema.org/unsaturatedFatContent");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public NutritionInformationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/NutritionInformation";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCaloriesList() {
        return this.getProperty("http://schema.org/calories");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCarbohydrateContentList() {
        return this.getProperty("http://schema.org/carbohydrateContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCholesterolContentList() {
        return this.getProperty("http://schema.org/cholesterolContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFatContentList() {
        return this.getProperty("http://schema.org/fatContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFiberContentList() {
        return this.getProperty("http://schema.org/fiberContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProteinContentList() {
        return this.getProperty("http://schema.org/proteinContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSaturatedFatContentList() {
        return this.getProperty("http://schema.org/saturatedFatContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServingSizeList() {
        return this.getProperty("http://schema.org/servingSize");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSodiumContentList() {
        return this.getProperty("http://schema.org/sodiumContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSugarContentList() {
        return this.getProperty("http://schema.org/sugarContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTransFatContentList() {
        return this.getProperty("http://schema.org/transFatContent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnsaturatedFatContentList() {
        return this.getProperty("http://schema.org/unsaturatedFatContent");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<NutritionInformation.Builder>
    implements NutritionInformation.Builder {
        BuilderImpl() {
        }

        @Override
        public NutritionInformation.Builder addAdditionalType(URL value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public NutritionInformation.Builder addAdditionalType(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addAlternateName(Text value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public NutritionInformation.Builder addAlternateName(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addCalories(Energy value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/calories", value);
        }

        @Override
        public NutritionInformation.Builder addCalories(Energy.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/calories", value.build());
        }

        @Override
        public NutritionInformation.Builder addCalories(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/calories", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addCarbohydrateContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/carbohydrateContent", value);
        }

        @Override
        public NutritionInformation.Builder addCarbohydrateContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/carbohydrateContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addCarbohydrateContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/carbohydrateContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addCholesterolContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/cholesterolContent", value);
        }

        @Override
        public NutritionInformation.Builder addCholesterolContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/cholesterolContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addCholesterolContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/cholesterolContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addDescription(Text value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public NutritionInformation.Builder addDescription(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addFatContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/fatContent", value);
        }

        @Override
        public NutritionInformation.Builder addFatContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/fatContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addFatContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/fatContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addFiberContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/fiberContent", value);
        }

        @Override
        public NutritionInformation.Builder addFiberContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/fiberContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addFiberContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/fiberContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addImage(ImageObject value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public NutritionInformation.Builder addImage(ImageObject.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public NutritionInformation.Builder addImage(URL value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public NutritionInformation.Builder addImage(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addMainEntityOfPage(CreativeWork value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public NutritionInformation.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public NutritionInformation.Builder addMainEntityOfPage(URL value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public NutritionInformation.Builder addMainEntityOfPage(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addName(Text value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public NutritionInformation.Builder addName(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addPotentialAction(Action value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public NutritionInformation.Builder addPotentialAction(Action.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public NutritionInformation.Builder addPotentialAction(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addProteinContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/proteinContent", value);
        }

        @Override
        public NutritionInformation.Builder addProteinContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/proteinContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addProteinContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/proteinContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addSameAs(URL value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public NutritionInformation.Builder addSameAs(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addSaturatedFatContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/saturatedFatContent", value);
        }

        @Override
        public NutritionInformation.Builder addSaturatedFatContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/saturatedFatContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addSaturatedFatContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/saturatedFatContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addServingSize(Text value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/servingSize", value);
        }

        @Override
        public NutritionInformation.Builder addServingSize(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/servingSize", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addSodiumContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sodiumContent", value);
        }

        @Override
        public NutritionInformation.Builder addSodiumContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sodiumContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addSodiumContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sodiumContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addSugarContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sugarContent", value);
        }

        @Override
        public NutritionInformation.Builder addSugarContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sugarContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addSugarContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/sugarContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addTransFatContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/transFatContent", value);
        }

        @Override
        public NutritionInformation.Builder addTransFatContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/transFatContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addTransFatContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/transFatContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addUnsaturatedFatContent(Mass value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/unsaturatedFatContent", value);
        }

        @Override
        public NutritionInformation.Builder addUnsaturatedFatContent(Mass.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/unsaturatedFatContent", value.build());
        }

        @Override
        public NutritionInformation.Builder addUnsaturatedFatContent(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/unsaturatedFatContent", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addUrl(URL value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public NutritionInformation.Builder addUrl(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addDetailedDescription(Article value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public NutritionInformation.Builder addDetailedDescription(Article.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public NutritionInformation.Builder addDetailedDescription(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public NutritionInformation.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public NutritionInformation.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public NutritionInformation.Builder addPopularityScore(String value) {
            return (NutritionInformation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public NutritionInformation build() {
            return new NutritionInformationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

