/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.ContactPoint;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Service;
import com.google.schemaorg.core.ServiceChannel;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ServiceChannelImpl
extends IntangibleImpl
implements ServiceChannel {
    private static final ImmutableSet<String> PROPERTY_SET = ServiceChannelImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/availableLanguage");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/processingTime");
        builder.add((Object)"http://schema.org/providesService");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/serviceLocation");
        builder.add((Object)"http://schema.org/servicePhone");
        builder.add((Object)"http://schema.org/servicePostalAddress");
        builder.add((Object)"http://schema.org/serviceSmsNumber");
        builder.add((Object)"http://schema.org/serviceUrl");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ServiceChannelImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/ServiceChannel";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableLanguageList() {
        return this.getProperty("http://schema.org/availableLanguage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProcessingTimeList() {
        return this.getProperty("http://schema.org/processingTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProvidesServiceList() {
        return this.getProperty("http://schema.org/providesService");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceLocationList() {
        return this.getProperty("http://schema.org/serviceLocation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServicePhoneList() {
        return this.getProperty("http://schema.org/servicePhone");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServicePostalAddressList() {
        return this.getProperty("http://schema.org/servicePostalAddress");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceSmsNumberList() {
        return this.getProperty("http://schema.org/serviceSmsNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getServiceUrlList() {
        return this.getProperty("http://schema.org/serviceUrl");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<ServiceChannel.Builder>
    implements ServiceChannel.Builder {
        BuilderImpl() {
        }

        @Override
        public ServiceChannel.Builder addAdditionalType(URL value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public ServiceChannel.Builder addAdditionalType(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addAlternateName(Text value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public ServiceChannel.Builder addAlternateName(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addAvailableLanguage(Language value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/availableLanguage", value);
        }

        @Override
        public ServiceChannel.Builder addAvailableLanguage(Language.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/availableLanguage", value.build());
        }

        @Override
        public ServiceChannel.Builder addAvailableLanguage(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/availableLanguage", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addDescription(Text value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public ServiceChannel.Builder addDescription(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addImage(ImageObject value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ServiceChannel.Builder addImage(ImageObject.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public ServiceChannel.Builder addImage(URL value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ServiceChannel.Builder addImage(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addMainEntityOfPage(CreativeWork value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ServiceChannel.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public ServiceChannel.Builder addMainEntityOfPage(URL value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ServiceChannel.Builder addMainEntityOfPage(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addName(Text value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public ServiceChannel.Builder addName(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addPotentialAction(Action value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public ServiceChannel.Builder addPotentialAction(Action.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public ServiceChannel.Builder addPotentialAction(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addProcessingTime(Duration value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/processingTime", value);
        }

        @Override
        public ServiceChannel.Builder addProcessingTime(Duration.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/processingTime", value.build());
        }

        @Override
        public ServiceChannel.Builder addProcessingTime(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/processingTime", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addProvidesService(Service value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/providesService", value);
        }

        @Override
        public ServiceChannel.Builder addProvidesService(Service.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/providesService", value.build());
        }

        @Override
        public ServiceChannel.Builder addProvidesService(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/providesService", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addSameAs(URL value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public ServiceChannel.Builder addSameAs(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addServiceLocation(Place value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceLocation", value);
        }

        @Override
        public ServiceChannel.Builder addServiceLocation(Place.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceLocation", value.build());
        }

        @Override
        public ServiceChannel.Builder addServiceLocation(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceLocation", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addServicePhone(ContactPoint value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/servicePhone", value);
        }

        @Override
        public ServiceChannel.Builder addServicePhone(ContactPoint.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/servicePhone", value.build());
        }

        @Override
        public ServiceChannel.Builder addServicePhone(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/servicePhone", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addServicePostalAddress(PostalAddress value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/servicePostalAddress", value);
        }

        @Override
        public ServiceChannel.Builder addServicePostalAddress(PostalAddress.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/servicePostalAddress", value.build());
        }

        @Override
        public ServiceChannel.Builder addServicePostalAddress(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/servicePostalAddress", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addServiceSmsNumber(ContactPoint value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceSmsNumber", value);
        }

        @Override
        public ServiceChannel.Builder addServiceSmsNumber(ContactPoint.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceSmsNumber", value.build());
        }

        @Override
        public ServiceChannel.Builder addServiceSmsNumber(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceSmsNumber", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addServiceUrl(URL value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceUrl", value);
        }

        @Override
        public ServiceChannel.Builder addServiceUrl(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/serviceUrl", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addUrl(URL value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public ServiceChannel.Builder addUrl(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addDetailedDescription(Article value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public ServiceChannel.Builder addDetailedDescription(Article.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public ServiceChannel.Builder addDetailedDescription(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public ServiceChannel.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public ServiceChannel.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public ServiceChannel.Builder addPopularityScore(String value) {
            return (ServiceChannel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public ServiceChannel build() {
            return new ServiceChannelImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

