/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Table;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.WebPageElementImpl;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class TableImpl
extends WebPageElementImpl
implements Table {
    private static final ImmutableSet<String> PROPERTY_SET = TableImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public TableImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Table";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Table.Builder>
    implements Table.Builder {
        BuilderImpl() {
        }

        @Override
        public Table.Builder addAbout(Thing value) {
            return (Table.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Table.Builder addAbout(Thing.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Table.Builder addAbout(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Table.Builder addAccessibilityAPI(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Table.Builder addAccessibilityAPI(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Table.Builder addAccessibilityControl(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Table.Builder addAccessibilityControl(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Table.Builder addAccessibilityFeature(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Table.Builder addAccessibilityFeature(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Table.Builder addAccessibilityHazard(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Table.Builder addAccessibilityHazard(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Table.Builder addAccountablePerson(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Table.Builder addAccountablePerson(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Table.Builder addAccountablePerson(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Table.Builder addAdditionalType(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Table.Builder addAdditionalType(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Table.Builder addAggregateRating(AggregateRating value) {
            return (Table.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Table.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Table.Builder addAggregateRating(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Table.Builder addAlternateName(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Table.Builder addAlternateName(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Table.Builder addAlternativeHeadline(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Table.Builder addAlternativeHeadline(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Table.Builder addAssociatedMedia(MediaObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Table.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Table.Builder addAssociatedMedia(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Table.Builder addAudience(Audience value) {
            return (Table.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Table.Builder addAudience(Audience.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Table.Builder addAudience(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Table.Builder addAudio(AudioObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Table.Builder addAudio(AudioObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Table.Builder addAudio(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Table.Builder addAuthor(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Table.Builder addAuthor(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Table.Builder addAuthor(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Table.Builder addAuthor(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Table.Builder addAuthor(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Table.Builder addAward(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Table.Builder addAward(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Table.Builder addAwards(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Table.Builder addAwards(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Table.Builder addCharacter(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Table.Builder addCharacter(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Table.Builder addCharacter(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Table.Builder addCitation(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Table.Builder addCitation(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Table.Builder addCitation(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Table.Builder addCitation(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Table.Builder addComment(Comment value) {
            return (Table.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Table.Builder addComment(Comment.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Table.Builder addComment(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Table.Builder addCommentCount(Integer value) {
            return (Table.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Table.Builder addCommentCount(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Table.Builder addContentLocation(Place value) {
            return (Table.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Table.Builder addContentLocation(Place.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Table.Builder addContentLocation(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Table.Builder addContentRating(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Table.Builder addContentRating(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Table.Builder addContributor(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Table.Builder addContributor(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Table.Builder addContributor(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Table.Builder addContributor(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Table.Builder addContributor(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Table.Builder addCopyrightHolder(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Table.Builder addCopyrightHolder(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Table.Builder addCopyrightHolder(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Table.Builder addCopyrightHolder(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Table.Builder addCopyrightHolder(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Table.Builder addCopyrightYear(Number value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Table.Builder addCopyrightYear(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Table.Builder addCreator(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Table.Builder addCreator(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Table.Builder addCreator(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Table.Builder addCreator(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Table.Builder addCreator(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Table.Builder addDateCreated(Date value) {
            return (Table.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Table.Builder addDateCreated(DateTime value) {
            return (Table.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Table.Builder addDateCreated(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Table.Builder addDateModified(Date value) {
            return (Table.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Table.Builder addDateModified(DateTime value) {
            return (Table.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Table.Builder addDateModified(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Table.Builder addDatePublished(Date value) {
            return (Table.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Table.Builder addDatePublished(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Table.Builder addDescription(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Table.Builder addDescription(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Table.Builder addDiscussionUrl(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Table.Builder addDiscussionUrl(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Table.Builder addEditor(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Table.Builder addEditor(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Table.Builder addEditor(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Table.Builder addEducationalAlignment(AlignmentObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Table.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Table.Builder addEducationalAlignment(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Table.Builder addEducationalUse(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Table.Builder addEducationalUse(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Table.Builder addEncoding(MediaObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Table.Builder addEncoding(MediaObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Table.Builder addEncoding(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Table.Builder addEncodings(MediaObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Table.Builder addEncodings(MediaObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Table.Builder addEncodings(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Table.Builder addExampleOfWork(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Table.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Table.Builder addExampleOfWork(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Table.Builder addFileFormat(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Table.Builder addFileFormat(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Table.Builder addGenre(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Table.Builder addGenre(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Table.Builder addGenre(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Table.Builder addHasPart(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Table.Builder addHasPart(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Table.Builder addHasPart(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Table.Builder addHeadline(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Table.Builder addHeadline(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Table.Builder addImage(ImageObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Table.Builder addImage(ImageObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Table.Builder addImage(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Table.Builder addImage(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Table.Builder addInLanguage(Language value) {
            return (Table.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Table.Builder addInLanguage(Language.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Table.Builder addInLanguage(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Table.Builder addInLanguage(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Table.Builder addInteractionStatistic(InteractionCounter value) {
            return (Table.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Table.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Table.Builder addInteractionStatistic(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Table.Builder addInteractivityType(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Table.Builder addInteractivityType(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Table.Builder addIsBasedOnUrl(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Table.Builder addIsBasedOnUrl(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Table.Builder addIsFamilyFriendly(Boolean value) {
            return (Table.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Table.Builder addIsFamilyFriendly(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Table.Builder addIsPartOf(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Table.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Table.Builder addIsPartOf(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Table.Builder addKeywords(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Table.Builder addKeywords(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Table.Builder addLearningResourceType(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Table.Builder addLearningResourceType(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Table.Builder addLicense(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Table.Builder addLicense(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Table.Builder addLicense(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Table.Builder addLicense(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Table.Builder addLocationCreated(Place value) {
            return (Table.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Table.Builder addLocationCreated(Place.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Table.Builder addLocationCreated(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Table.Builder addMainEntity(Thing value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Table.Builder addMainEntity(Thing.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Table.Builder addMainEntity(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Table.Builder addMainEntityOfPage(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Table.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Table.Builder addMainEntityOfPage(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Table.Builder addMainEntityOfPage(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Table.Builder addMentions(Thing value) {
            return (Table.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Table.Builder addMentions(Thing.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Table.Builder addMentions(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Table.Builder addName(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Table.Builder addName(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Table.Builder addOffers(Offer value) {
            return (Table.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Table.Builder addOffers(Offer.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Table.Builder addOffers(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Table.Builder addPosition(Integer value) {
            return (Table.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Table.Builder addPosition(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Table.Builder addPosition(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Table.Builder addPotentialAction(Action value) {
            return (Table.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Table.Builder addPotentialAction(Action.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Table.Builder addPotentialAction(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Table.Builder addProducer(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Table.Builder addProducer(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Table.Builder addProducer(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Table.Builder addProducer(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Table.Builder addProducer(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Table.Builder addProvider(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Table.Builder addProvider(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Table.Builder addProvider(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Table.Builder addProvider(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Table.Builder addProvider(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Table.Builder addPublication(PublicationEvent value) {
            return (Table.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Table.Builder addPublication(PublicationEvent.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Table.Builder addPublication(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Table.Builder addPublisher(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Table.Builder addPublisher(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Table.Builder addPublisher(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Table.Builder addPublisher(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Table.Builder addPublisher(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Table.Builder addPublishingPrinciples(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Table.Builder addPublishingPrinciples(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Table.Builder addRecordedAt(Event value) {
            return (Table.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Table.Builder addRecordedAt(Event.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Table.Builder addRecordedAt(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Table.Builder addReleasedEvent(PublicationEvent value) {
            return (Table.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Table.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Table.Builder addReleasedEvent(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Table.Builder addReview(Review value) {
            return (Table.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Table.Builder addReview(Review.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Table.Builder addReview(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Table.Builder addReviews(Review value) {
            return (Table.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Table.Builder addReviews(Review.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Table.Builder addReviews(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Table.Builder addSameAs(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Table.Builder addSameAs(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Table.Builder addSchemaVersion(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Table.Builder addSchemaVersion(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Table.Builder addSchemaVersion(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Table.Builder addSourceOrganization(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Table.Builder addSourceOrganization(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Table.Builder addSourceOrganization(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Table.Builder addText(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Table.Builder addText(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Table.Builder addThumbnailUrl(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Table.Builder addThumbnailUrl(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Table.Builder addTimeRequired(Duration value) {
            return (Table.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Table.Builder addTimeRequired(Duration.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Table.Builder addTimeRequired(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Table.Builder addTranslator(Organization value) {
            return (Table.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Table.Builder addTranslator(Organization.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Table.Builder addTranslator(Person value) {
            return (Table.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Table.Builder addTranslator(Person.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Table.Builder addTranslator(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Table.Builder addTypicalAgeRange(Text value) {
            return (Table.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Table.Builder addTypicalAgeRange(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Table.Builder addUrl(URL value) {
            return (Table.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Table.Builder addUrl(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Table.Builder addVersion(Number value) {
            return (Table.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Table.Builder addVersion(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Table.Builder addVideo(VideoObject value) {
            return (Table.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Table.Builder addVideo(VideoObject.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Table.Builder addVideo(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Table.Builder addWorkExample(CreativeWork value) {
            return (Table.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Table.Builder addWorkExample(CreativeWork.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Table.Builder addWorkExample(String value) {
            return (Table.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Table.Builder addDetailedDescription(Article value) {
            return (Table.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Table.Builder addDetailedDescription(Article.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Table.Builder addDetailedDescription(String value) {
            return (Table.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Table.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Table.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Table.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Table.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Table.Builder addPopularityScore(String value) {
            return (Table.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Table build() {
            return new TableImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

