/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Distance;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MediaObjectImpl;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.NewsArticle;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class VideoObjectImpl
extends MediaObjectImpl
implements VideoObject {
    private static final ImmutableSet<String> PROPERTY_SET = VideoObjectImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/actor");
        builder.add((Object)"http://schema.org/actors");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedArticle");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/bitrate");
        builder.add((Object)"http://schema.org/caption");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contentSize");
        builder.add((Object)"http://schema.org/contentUrl");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/director");
        builder.add((Object)"http://schema.org/directors");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/embedUrl");
        builder.add((Object)"http://schema.org/encodesCreativeWork");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodingFormat");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/expires");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/height");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicBy");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/playerType");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/productionCompany");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/regionsAllowed");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/requiresSubscription");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnail");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/transcript");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/uploadDate");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/videoFrameSize");
        builder.add((Object)"http://schema.org/videoQuality");
        builder.add((Object)"http://schema.org/width");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public VideoObjectImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/VideoObject";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorList() {
        return this.getProperty("http://schema.org/actor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorsList() {
        return this.getProperty("http://schema.org/actors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCaptionList() {
        return this.getProperty("http://schema.org/caption");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorList() {
        return this.getProperty("http://schema.org/director");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorsList() {
        return this.getProperty("http://schema.org/directors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicByList() {
        return this.getProperty("http://schema.org/musicBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getThumbnailList() {
        return this.getProperty("http://schema.org/thumbnail");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTranscriptList() {
        return this.getProperty("http://schema.org/transcript");
    }

    @Override
    public ImmutableList<SchemaOrgType> getVideoFrameSizeList() {
        return this.getProperty("http://schema.org/videoFrameSize");
    }

    @Override
    public ImmutableList<SchemaOrgType> getVideoQualityList() {
        return this.getProperty("http://schema.org/videoQuality");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<VideoObject.Builder>
    implements VideoObject.Builder {
        BuilderImpl() {
        }

        @Override
        public VideoObject.Builder addAbout(Thing value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public VideoObject.Builder addAbout(Thing.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public VideoObject.Builder addAbout(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAccessibilityAPI(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public VideoObject.Builder addAccessibilityAPI(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAccessibilityControl(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public VideoObject.Builder addAccessibilityControl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAccessibilityFeature(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public VideoObject.Builder addAccessibilityFeature(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAccessibilityHazard(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public VideoObject.Builder addAccessibilityHazard(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAccountablePerson(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public VideoObject.Builder addAccountablePerson(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public VideoObject.Builder addAccountablePerson(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public VideoObject.Builder addActor(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/actor", value);
        }

        @Override
        public VideoObject.Builder addActor(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/actor", value.build());
        }

        @Override
        public VideoObject.Builder addActor(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/actor", Text.of(value));
        }

        @Override
        public VideoObject.Builder addActors(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/actors", value);
        }

        @Override
        public VideoObject.Builder addActors(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/actors", value.build());
        }

        @Override
        public VideoObject.Builder addActors(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/actors", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAdditionalType(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public VideoObject.Builder addAdditionalType(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAggregateRating(AggregateRating value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public VideoObject.Builder addAggregateRating(AggregateRating.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public VideoObject.Builder addAggregateRating(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAlternateName(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public VideoObject.Builder addAlternateName(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAlternativeHeadline(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public VideoObject.Builder addAlternativeHeadline(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAssociatedArticle(NewsArticle value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/associatedArticle", value);
        }

        @Override
        public VideoObject.Builder addAssociatedArticle(NewsArticle.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/associatedArticle", value.build());
        }

        @Override
        public VideoObject.Builder addAssociatedArticle(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/associatedArticle", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAssociatedMedia(MediaObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public VideoObject.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public VideoObject.Builder addAssociatedMedia(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAudience(Audience value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public VideoObject.Builder addAudience(Audience.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public VideoObject.Builder addAudience(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAudio(AudioObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public VideoObject.Builder addAudio(AudioObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public VideoObject.Builder addAudio(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAuthor(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public VideoObject.Builder addAuthor(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public VideoObject.Builder addAuthor(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public VideoObject.Builder addAuthor(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public VideoObject.Builder addAuthor(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAward(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public VideoObject.Builder addAward(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public VideoObject.Builder addAwards(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public VideoObject.Builder addAwards(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public VideoObject.Builder addBitrate(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/bitrate", value);
        }

        @Override
        public VideoObject.Builder addBitrate(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/bitrate", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCaption(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/caption", value);
        }

        @Override
        public VideoObject.Builder addCaption(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/caption", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCharacter(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public VideoObject.Builder addCharacter(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public VideoObject.Builder addCharacter(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCitation(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public VideoObject.Builder addCitation(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public VideoObject.Builder addCitation(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public VideoObject.Builder addCitation(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public VideoObject.Builder addComment(Comment value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public VideoObject.Builder addComment(Comment.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public VideoObject.Builder addComment(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCommentCount(Integer value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public VideoObject.Builder addCommentCount(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public VideoObject.Builder addContentLocation(Place value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public VideoObject.Builder addContentLocation(Place.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public VideoObject.Builder addContentLocation(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public VideoObject.Builder addContentRating(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public VideoObject.Builder addContentRating(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public VideoObject.Builder addContentSize(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentSize", value);
        }

        @Override
        public VideoObject.Builder addContentSize(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentSize", Text.of(value));
        }

        @Override
        public VideoObject.Builder addContentUrl(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentUrl", value);
        }

        @Override
        public VideoObject.Builder addContentUrl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contentUrl", Text.of(value));
        }

        @Override
        public VideoObject.Builder addContributor(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public VideoObject.Builder addContributor(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public VideoObject.Builder addContributor(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public VideoObject.Builder addContributor(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public VideoObject.Builder addContributor(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCopyrightHolder(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public VideoObject.Builder addCopyrightHolder(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public VideoObject.Builder addCopyrightHolder(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public VideoObject.Builder addCopyrightHolder(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public VideoObject.Builder addCopyrightHolder(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCopyrightYear(Number value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public VideoObject.Builder addCopyrightYear(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public VideoObject.Builder addCreator(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public VideoObject.Builder addCreator(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public VideoObject.Builder addCreator(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public VideoObject.Builder addCreator(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public VideoObject.Builder addCreator(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDateCreated(Date value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public VideoObject.Builder addDateCreated(DateTime value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public VideoObject.Builder addDateCreated(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDateModified(Date value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public VideoObject.Builder addDateModified(DateTime value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public VideoObject.Builder addDateModified(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDatePublished(Date value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public VideoObject.Builder addDatePublished(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDescription(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public VideoObject.Builder addDescription(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDirector(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/director", value);
        }

        @Override
        public VideoObject.Builder addDirector(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/director", value.build());
        }

        @Override
        public VideoObject.Builder addDirector(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/director", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDirectors(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/directors", value);
        }

        @Override
        public VideoObject.Builder addDirectors(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/directors", value.build());
        }

        @Override
        public VideoObject.Builder addDirectors(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/directors", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDiscussionUrl(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public VideoObject.Builder addDiscussionUrl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDuration(Duration value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public VideoObject.Builder addDuration(Duration.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public VideoObject.Builder addDuration(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEditor(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public VideoObject.Builder addEditor(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public VideoObject.Builder addEditor(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEducationalAlignment(AlignmentObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public VideoObject.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public VideoObject.Builder addEducationalAlignment(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEducationalUse(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public VideoObject.Builder addEducationalUse(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEmbedUrl(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/embedUrl", value);
        }

        @Override
        public VideoObject.Builder addEmbedUrl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/embedUrl", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEncodesCreativeWork(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodesCreativeWork", value);
        }

        @Override
        public VideoObject.Builder addEncodesCreativeWork(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodesCreativeWork", value.build());
        }

        @Override
        public VideoObject.Builder addEncodesCreativeWork(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodesCreativeWork", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEncoding(MediaObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public VideoObject.Builder addEncoding(MediaObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public VideoObject.Builder addEncoding(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEncodingFormat(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodingFormat", value);
        }

        @Override
        public VideoObject.Builder addEncodingFormat(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodingFormat", Text.of(value));
        }

        @Override
        public VideoObject.Builder addEncodings(MediaObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public VideoObject.Builder addEncodings(MediaObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public VideoObject.Builder addEncodings(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public VideoObject.Builder addExampleOfWork(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public VideoObject.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public VideoObject.Builder addExampleOfWork(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public VideoObject.Builder addExpires(Date value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/expires", value);
        }

        @Override
        public VideoObject.Builder addExpires(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/expires", Text.of(value));
        }

        @Override
        public VideoObject.Builder addFileFormat(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public VideoObject.Builder addFileFormat(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public VideoObject.Builder addGenre(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public VideoObject.Builder addGenre(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public VideoObject.Builder addGenre(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public VideoObject.Builder addHasPart(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public VideoObject.Builder addHasPart(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public VideoObject.Builder addHasPart(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public VideoObject.Builder addHeadline(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public VideoObject.Builder addHeadline(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public VideoObject.Builder addHeight(Distance value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public VideoObject.Builder addHeight(Distance.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public VideoObject.Builder addHeight(QuantitativeValue value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/height", value);
        }

        @Override
        public VideoObject.Builder addHeight(QuantitativeValue.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/height", value.build());
        }

        @Override
        public VideoObject.Builder addHeight(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/height", Text.of(value));
        }

        @Override
        public VideoObject.Builder addImage(ImageObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public VideoObject.Builder addImage(ImageObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public VideoObject.Builder addImage(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public VideoObject.Builder addImage(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public VideoObject.Builder addInLanguage(Language value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public VideoObject.Builder addInLanguage(Language.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public VideoObject.Builder addInLanguage(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public VideoObject.Builder addInLanguage(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public VideoObject.Builder addInteractionStatistic(InteractionCounter value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public VideoObject.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public VideoObject.Builder addInteractionStatistic(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public VideoObject.Builder addInteractivityType(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public VideoObject.Builder addInteractivityType(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public VideoObject.Builder addIsBasedOnUrl(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public VideoObject.Builder addIsBasedOnUrl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public VideoObject.Builder addIsFamilyFriendly(Boolean value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public VideoObject.Builder addIsFamilyFriendly(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public VideoObject.Builder addIsPartOf(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public VideoObject.Builder addIsPartOf(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public VideoObject.Builder addIsPartOf(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public VideoObject.Builder addKeywords(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public VideoObject.Builder addKeywords(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public VideoObject.Builder addLearningResourceType(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public VideoObject.Builder addLearningResourceType(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public VideoObject.Builder addLicense(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public VideoObject.Builder addLicense(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public VideoObject.Builder addLicense(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public VideoObject.Builder addLicense(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public VideoObject.Builder addLocationCreated(Place value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public VideoObject.Builder addLocationCreated(Place.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public VideoObject.Builder addLocationCreated(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public VideoObject.Builder addMainEntity(Thing value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public VideoObject.Builder addMainEntity(Thing.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public VideoObject.Builder addMainEntity(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public VideoObject.Builder addMainEntityOfPage(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public VideoObject.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public VideoObject.Builder addMainEntityOfPage(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public VideoObject.Builder addMainEntityOfPage(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public VideoObject.Builder addMentions(Thing value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public VideoObject.Builder addMentions(Thing.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public VideoObject.Builder addMentions(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public VideoObject.Builder addMusicBy(MusicGroup value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public VideoObject.Builder addMusicBy(MusicGroup.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public VideoObject.Builder addMusicBy(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public VideoObject.Builder addMusicBy(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public VideoObject.Builder addMusicBy(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/musicBy", Text.of(value));
        }

        @Override
        public VideoObject.Builder addName(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public VideoObject.Builder addName(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public VideoObject.Builder addOffers(Offer value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public VideoObject.Builder addOffers(Offer.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public VideoObject.Builder addOffers(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPlayerType(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/playerType", value);
        }

        @Override
        public VideoObject.Builder addPlayerType(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/playerType", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPosition(Integer value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public VideoObject.Builder addPosition(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public VideoObject.Builder addPosition(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPotentialAction(Action value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public VideoObject.Builder addPotentialAction(Action.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public VideoObject.Builder addPotentialAction(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public VideoObject.Builder addProducer(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public VideoObject.Builder addProducer(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public VideoObject.Builder addProducer(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public VideoObject.Builder addProducer(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public VideoObject.Builder addProducer(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public VideoObject.Builder addProductionCompany(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/productionCompany", value);
        }

        @Override
        public VideoObject.Builder addProductionCompany(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/productionCompany", value.build());
        }

        @Override
        public VideoObject.Builder addProductionCompany(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/productionCompany", Text.of(value));
        }

        @Override
        public VideoObject.Builder addProvider(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public VideoObject.Builder addProvider(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public VideoObject.Builder addProvider(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public VideoObject.Builder addProvider(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public VideoObject.Builder addProvider(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPublication(PublicationEvent value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public VideoObject.Builder addPublication(PublicationEvent.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public VideoObject.Builder addPublication(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPublisher(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public VideoObject.Builder addPublisher(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public VideoObject.Builder addPublisher(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public VideoObject.Builder addPublisher(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public VideoObject.Builder addPublisher(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPublishingPrinciples(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public VideoObject.Builder addPublishingPrinciples(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public VideoObject.Builder addRecordedAt(Event value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public VideoObject.Builder addRecordedAt(Event.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public VideoObject.Builder addRecordedAt(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public VideoObject.Builder addRegionsAllowed(Place value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/regionsAllowed", value);
        }

        @Override
        public VideoObject.Builder addRegionsAllowed(Place.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/regionsAllowed", value.build());
        }

        @Override
        public VideoObject.Builder addRegionsAllowed(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/regionsAllowed", Text.of(value));
        }

        @Override
        public VideoObject.Builder addReleasedEvent(PublicationEvent value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public VideoObject.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public VideoObject.Builder addReleasedEvent(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public VideoObject.Builder addRequiresSubscription(Boolean value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/requiresSubscription", value);
        }

        @Override
        public VideoObject.Builder addRequiresSubscription(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/requiresSubscription", Text.of(value));
        }

        @Override
        public VideoObject.Builder addReview(Review value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public VideoObject.Builder addReview(Review.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public VideoObject.Builder addReview(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public VideoObject.Builder addReviews(Review value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public VideoObject.Builder addReviews(Review.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public VideoObject.Builder addReviews(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public VideoObject.Builder addSameAs(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public VideoObject.Builder addSameAs(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public VideoObject.Builder addSchemaVersion(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public VideoObject.Builder addSchemaVersion(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public VideoObject.Builder addSchemaVersion(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public VideoObject.Builder addSourceOrganization(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public VideoObject.Builder addSourceOrganization(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public VideoObject.Builder addSourceOrganization(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public VideoObject.Builder addText(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public VideoObject.Builder addText(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public VideoObject.Builder addThumbnail(ImageObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/thumbnail", value);
        }

        @Override
        public VideoObject.Builder addThumbnail(ImageObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/thumbnail", value.build());
        }

        @Override
        public VideoObject.Builder addThumbnail(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/thumbnail", Text.of(value));
        }

        @Override
        public VideoObject.Builder addThumbnailUrl(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public VideoObject.Builder addThumbnailUrl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public VideoObject.Builder addTimeRequired(Duration value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public VideoObject.Builder addTimeRequired(Duration.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public VideoObject.Builder addTimeRequired(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public VideoObject.Builder addTranscript(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/transcript", value);
        }

        @Override
        public VideoObject.Builder addTranscript(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/transcript", Text.of(value));
        }

        @Override
        public VideoObject.Builder addTranslator(Organization value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public VideoObject.Builder addTranslator(Organization.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public VideoObject.Builder addTranslator(Person value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public VideoObject.Builder addTranslator(Person.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public VideoObject.Builder addTranslator(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public VideoObject.Builder addTypicalAgeRange(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public VideoObject.Builder addTypicalAgeRange(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public VideoObject.Builder addUploadDate(Date value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/uploadDate", value);
        }

        @Override
        public VideoObject.Builder addUploadDate(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/uploadDate", Text.of(value));
        }

        @Override
        public VideoObject.Builder addUrl(URL value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public VideoObject.Builder addUrl(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public VideoObject.Builder addVersion(Number value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public VideoObject.Builder addVersion(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public VideoObject.Builder addVideo(VideoObject value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public VideoObject.Builder addVideo(VideoObject.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public VideoObject.Builder addVideo(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public VideoObject.Builder addVideoFrameSize(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/videoFrameSize", value);
        }

        @Override
        public VideoObject.Builder addVideoFrameSize(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/videoFrameSize", Text.of(value));
        }

        @Override
        public VideoObject.Builder addVideoQuality(Text value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/videoQuality", value);
        }

        @Override
        public VideoObject.Builder addVideoQuality(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/videoQuality", Text.of(value));
        }

        @Override
        public VideoObject.Builder addWidth(Distance value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public VideoObject.Builder addWidth(Distance.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public VideoObject.Builder addWidth(QuantitativeValue value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/width", value);
        }

        @Override
        public VideoObject.Builder addWidth(QuantitativeValue.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/width", value.build());
        }

        @Override
        public VideoObject.Builder addWidth(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/width", Text.of(value));
        }

        @Override
        public VideoObject.Builder addWorkExample(CreativeWork value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public VideoObject.Builder addWorkExample(CreativeWork.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public VideoObject.Builder addWorkExample(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public VideoObject.Builder addDetailedDescription(Article value) {
            return (VideoObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public VideoObject.Builder addDetailedDescription(Article.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public VideoObject.Builder addDetailedDescription(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public VideoObject.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (VideoObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public VideoObject.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (VideoObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public VideoObject.Builder addPopularityScore(String value) {
            return (VideoObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public VideoObject build() {
            return new VideoObjectImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

