/*
 * Decompiled with CFR 0.152.
 */
package com.github.mayp1998.taskExecutor.bean;

import java.util.Date;
import java.util.concurrent.Future;

public class Task {
    private boolean type;
    private Date start;
    private Integer period;
    private Boolean isRunNow = false;
    private String cron;
    private int maxRunNumber = 0;
    private int run = 0;
    private Runnable runnable;
    private Future<?> future;

    public Task(Runnable runnable) {
        this.start = null;
        this.period = null;
        this.runnable = runnable;
        this.isRunNow = true;
        this.type = false;
    }

    public Task(Runnable runnable, Date start, Integer period, Boolean ... runNow) {
        this.start = start;
        this.period = period != null && period < 0 ? null : period;
        this.runnable = runnable;
        Boolean isRun = false;
        for (Boolean i : runNow) {
            if (i == null) continue;
            isRun = i;
        }
        this.isRunNow = isRun;
        this.type = false;
    }

    public Task(Runnable runnable, String cron) {
        this.type = true;
        this.runnable = runnable;
        this.cron = cron;
    }

    public Task setMaxRunNumber(int runNumber) {
        this.maxRunNumber = runNumber;
        return this;
    }

    public Task cancelMaxRunNumber() {
        this.maxRunNumber = 0;
        return this;
    }

    protected void finalize() throws Throwable {
        this.stop(false);
        super.finalize();
    }

    public final Boolean stop(boolean isForceToStop) {
        if (this.future != null) {
            return this.future.cancel(isForceToStop);
        }
        return null;
    }

    public final Date getStart() {
        return this.start;
    }

    public final Integer getPeriod() {
        return this.period != null && this.period < 0 ? null : this.period;
    }

    public final Boolean isRunNow() {
        return this.isRunNow;
    }

    public final Runnable getRunnable() {
        return this.runnable;
    }

    public final Future<?> getFuture() {
        return this.future;
    }

    public final void setFuture(Future<?> future) {
        this.future = future;
    }

    public final boolean isType() {
        return this.type;
    }

    public final String getCron() {
        return this.cron;
    }

    public final int getMaxRunNumber() {
        return this.maxRunNumber;
    }

    public final int getRun() {
        return this.run;
    }

    public final void setRun(int run) {
        this.run = run;
    }
}

