/*
 * Decompiled with CFR 0.152.
 */
package com.github.mayp1998.taskExecutor.util;

import com.github.mayp1998.taskExecutor.bean.Task;
import com.github.mayp1998.taskExecutor.util.LimitedTaskRunnable;
import com.github.mayp1998.taskExecutor.util.TaskRunnable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TaskExecutor {
    private Map<String, Task> group = new ConcurrentHashMap<String, Task>();
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    private TaskExecutor() {
    }

    public static TaskExecutor getInstance() {
        return Singleton.instance;
    }

    public static TaskExecutor getNewInstance() {
        return new TaskExecutor();
    }

    protected void finalize() throws Throwable {
        this.shutdownAll(new boolean[0]);
        super.finalize();
    }

    public void shutdownAll(boolean ... isForceToStop) {
        boolean forceToStop = false;
        Object object = isForceToStop;
        int n = ((boolean[])object).length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = object[i];
        }
        object = this.group.keySet().iterator();
        while (object.hasNext()) {
            String id = (String)object.next();
            if (id == null) continue;
            this.shutdownTask(id, forceToStop);
        }
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.group.clear();
        this.group = new ConcurrentHashMap<String, Task>();
    }

    public Map<String, Integer> getAllTaskRunNumber() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, Task> task : this.group.entrySet()) {
            result.put(task.getKey(), task.getValue().getRun());
        }
        return result;
    }

    public Integer getTaskRunNumber(String taskId) {
        if (this.group.containsKey(taskId)) {
            return this.group.get(taskId).getRun();
        }
        return null;
    }

    public Task getTask(String taskId) {
        if (this.group.containsKey(taskId)) {
            return this.group.get(taskId);
        }
        return null;
    }

    public Map<String, Boolean> getAllTaskStatus() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map.Entry<String, Task> task : this.group.entrySet()) {
            result.put(task.getKey(), task.getValue().getFuture() != null);
        }
        return result;
    }

    public Boolean getTaskStatus(String taskId) {
        if (this.group.containsKey(taskId)) {
            Task task = this.group.get(taskId);
            return task.getFuture() != null;
        }
        return null;
    }

    public void alterAndRunTask(String taskId, Task newTask, boolean ... isForceToStop) {
        boolean forceToStop = false;
        boolean[] blArray = isForceToStop;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = blArray[i];
        }
        if (taskId != null && newTask != null) {
            this.alterTask(taskId, newTask, forceToStop);
            this.startTask(taskId);
        }
    }

    public void alterAndRunTasks(Map<String, Task> newTaskMap, boolean ... isForceToStop) {
        boolean forceToStop = false;
        Object object = isForceToStop;
        int n = ((boolean[])object).length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = object[i];
        }
        object = newTaskMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry newTask = (Map.Entry)object.next();
            this.alterAndRunTask((String)newTask.getKey(), (Task)newTask.getValue(), forceToStop);
        }
    }

    public void alterTask(String taskId, Task newTask, boolean ... isForceToStop) {
        boolean forceToStop = false;
        boolean[] blArray = isForceToStop;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = blArray[i];
        }
        if (taskId != null && newTask != null) {
            if (this.group.containsKey(taskId)) {
                Task task = this.group.get(taskId);
                if (task.getFuture() != null) {
                    task.stop(forceToStop);
                    task.setFuture(null);
                }
                this.group.remove(taskId);
            }
            this.group.put(taskId, newTask);
        }
    }

    public void alterTasks(Map<String, Task> newTaskMap, boolean ... isForceToStop) {
        boolean forceToStop = false;
        Object object = isForceToStop;
        int n = ((boolean[])object).length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = object[i];
        }
        object = newTaskMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry newTask = (Map.Entry)object.next();
            this.alterTask((String)newTask.getKey(), (Task)newTask.getValue(), forceToStop);
        }
    }

    public boolean pauseTask(String taskId, boolean ... isForceToStop) {
        boolean forceToStop = false;
        boolean[] blArray = isForceToStop;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = blArray[i];
        }
        if (this.group.containsKey(taskId)) {
            Task task = this.group.get(taskId);
            task.stop(forceToStop || task.isType());
            task.setFuture(null);
            return true;
        }
        return false;
    }

    public void pauseTasks(List<String> idList, boolean ... isForceToStop) {
        boolean forceToStop = false;
        Object object = isForceToStop;
        int n = ((boolean[])object).length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = object[i];
        }
        object = idList.iterator();
        while (object.hasNext()) {
            String id = (String)object.next();
            if (id == null) continue;
            this.pauseTask(id, forceToStop);
        }
    }

    public void runTask(String taskId, Task task) {
        this.addTask(taskId, task);
        this.startTask(taskId);
    }

    public void runTasks(Map<String, Task> taskMap) {
        this.addTasks(taskMap);
        for (Map.Entry<String, Task> newTask : taskMap.entrySet()) {
            Task task = newTask.getValue();
            if (newTask.getKey() == null || task == null) continue;
            this.startTask(task);
        }
    }

    public void addTask(String taskId, Task task) {
        if (taskId != null && task != null) {
            this.group.put(taskId, task);
        }
    }

    public void addTasks(Map<String, Task> taskMap) {
        for (Map.Entry<String, Task> newTask : taskMap.entrySet()) {
            this.addTask(newTask.getKey(), newTask.getValue());
        }
    }

    public boolean startTask(String taskId) {
        if (this.group.containsKey(taskId)) {
            this.startTask(this.group.get(taskId));
            return true;
        }
        return false;
    }

    public void startTasks(List<String> idList) {
        for (String id : idList) {
            if (id == null) continue;
            this.startTask(id);
        }
    }

    public Boolean shutdownTask(String taskId, boolean ... isForceToStop) {
        boolean forceToStop = false;
        boolean[] blArray = isForceToStop;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = blArray[i];
        }
        if (this.group.containsKey(taskId)) {
            Task task = this.group.get(taskId);
            Boolean result = task.stop(forceToStop || task.isType());
            task.setFuture(null);
            this.group.remove(taskId);
            return result;
        }
        return null;
    }

    public void shutdownTasks(List<String> idList, boolean ... isForceToStop) {
        boolean forceToStop = false;
        Object object = isForceToStop;
        int n = ((boolean[])object).length;
        for (int i = 0; i < n; ++i) {
            boolean i2;
            forceToStop = i2 = object[i];
        }
        object = idList.iterator();
        while (object.hasNext()) {
            String id = (String)object.next();
            this.shutdownTask(id, forceToStop);
        }
    }

    private void startTask(Task task) {
        if (task.getFuture() == null) {
            if (!task.isType()) {
                Date start = task.getStart();
                Integer period = task.getPeriod();
                Boolean isRunNow = task.isRunNow();
                LimitedTaskRunnable runnable = new LimitedTaskRunnable(task);
                ScheduledFuture<?> future = null;
                if (isRunNow.booleanValue()) {
                    this.service.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
                }
                if (start != null && period != null) {
                    long starttemp = start.getTime();
                    long periodtemp = period * 1000;
                    int starttime = (int)(starttemp - new Date().getTime());
                    while (starttime < 0) {
                        starttime = (int)((starttemp += periodtemp) - new Date().getTime());
                    }
                    future = this.service.scheduleAtFixedRate(runnable, starttime, period * 1000, TimeUnit.MILLISECONDS);
                } else if (start == null && period != null) {
                    future = this.service.scheduleAtFixedRate(runnable, period * 1000, period * 1000, TimeUnit.MILLISECONDS);
                } else if (start != null) {
                    long starttemp = start.getTime();
                    int starttime = (int)(starttemp - new Date().getTime());
                    future = this.service.schedule(runnable, (long)starttime, TimeUnit.MILLISECONDS);
                }
                task.setFuture(future);
            } else {
                TaskRunnable runnable = new TaskRunnable(new LimitedTaskRunnable(task), task.getCron(), task, this.service);
                ScheduledFuture<?> future = this.service.schedule(runnable, runnable.getNextTriggerTime(), TimeUnit.MILLISECONDS);
                task.setFuture(future);
            }
        }
    }

    private static class Singleton {
        private static TaskExecutor instance = new TaskExecutor();

        private Singleton() {
        }
    }
}

