/*
 * Decompiled with CFR 0.152.
 */
package com.github.mayp1998.taskExecutor.util;

import com.github.mayp1998.taskExecutor.bean.Task;
import java.util.concurrent.Future;

public class LimitedTaskRunnable
implements Runnable {
    private Task task;
    private Runnable runnable;
    private boolean type;
    private long runNumber;
    private long run;

    public LimitedTaskRunnable(Task task) {
        this.task = task;
        this.runnable = task.getRunnable();
        if (task.getMaxRunNumber() > 0L) {
            this.type = true;
            this.runNumber = task.getMaxRunNumber();
        } else {
            this.type = false;
        }
        this.run = 0L;
    }

    @Override
    public void run() {
        if (this.type && this.run >= this.runNumber) {
            Future<?> future = this.task.getFuture();
            this.task.setFuture(null);
            future.cancel(true);
        } else {
            this.runnable.run();
            ++this.run;
            this.task.setRun(this.task.getRun() + 1L);
            if (this.type && this.run >= this.runNumber) {
                Future<?> future = this.task.getFuture();
                this.task.setFuture(null);
                future.cancel(true);
            }
        }
    }
}

