/*
 * Decompiled with CFR 0.152.
 */
package com.evgenbar.binarydecoder;

import com.evgenbar.binarydecoder.Decodable;
import com.evgenbar.binarydecoder.DecodeUnsigned;
import com.evgenbar.binarydecoder.IDataInputDecoder;
import com.evgenbar.binarydecoder.SizedBy;
import com.evgenbar.binarydecoder.ThrowingFunction;
import com.google.common.collect.ImmutableMap;
import java.io.DataInput;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;

public class BinaryDataDecoder
implements IDataInputDecoder {
    static final Map<Class<?>, ThrowingFunction<DataInput, Object>> PrimitiveDecoders = ImmutableMap.builder().put(Boolean.class, input -> input.readBoolean()).put(Character.class, input -> Character.valueOf(input.readChar())).put(Byte.class, input -> input.readByte()).put(Short.class, input -> input.readShort()).put(Integer.class, input -> input.readInt()).put(Long.class, input -> input.readLong()).put(Float.class, input -> Float.valueOf(input.readFloat())).put(Double.class, input -> input.readDouble()).build();
    static final Map<DecodeUnsigned.IntegerType, ThrowingFunction<DataInput, Object>> UnsignedDecoders = ImmutableMap.builder().put((Object)DecodeUnsigned.IntegerType.UnsignedByte, input -> input.readUnsignedByte()).put((Object)DecodeUnsigned.IntegerType.UnsignedShort, input -> input.readUnsignedShort()).put((Object)DecodeUnsigned.IntegerType.UnsignedInt, input -> Integer.toUnsignedLong(input.readInt())).build();

    @Override
    public <T> T decode(Class<T> type, DataInput input) {
        T object;
        try {
            object = type.newInstance();
            this.decodeObject(object, type, input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    @Override
    public <T> T[] decode(Class<T> type, int arrayLength, DataInput input) {
        Object[] array;
        try {
            array = (Object[])Array.newInstance(type, arrayLength);
            this.decodeArray(array, type, null, input);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return array;
    }

    private void decodeArray(Object array, Class<?> elementType, DecodeUnsigned decodeUnsigned, DataInput input) throws InstantiationException, IllegalAccessException {
        elementType = ClassUtils.primitiveToWrapper(elementType);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = PrimitiveDecoders.containsKey(elementType) ? this.decodePrimitive(input, elementType, decodeUnsigned) : this.decode(elementType, input);
            Array.set(array, i, element);
        }
    }

    private void decodeObject(Object o, Class<?> objectType, DataInput input) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (objectType.getDeclaredAnnotation(Decodable.class) == null) {
            return;
        }
        Class<?> superType = objectType.getSuperclass();
        if (superType != null) {
            this.decodeObject(o, superType, input);
        }
        for (Field field : objectType.getDeclaredFields()) {
            Object fieldObject;
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class fieldType = ClassUtils.primitiveToWrapper(field.getType());
            field.setAccessible(true);
            if (PrimitiveDecoders.containsKey(fieldType)) {
                fieldObject = this.decodePrimitive(input, fieldType, field.getAnnotation(DecodeUnsigned.class));
            } else if (!fieldType.isArray()) {
                if (fieldType.getDeclaredAnnotation(Decodable.class) == null) continue;
                fieldObject = this.decode(fieldType, input);
            } else {
                SizedBy sizedBy = field.getAnnotation(SizedBy.class);
                if (sizedBy == null) {
                    fieldObject = field.get(o);
                } else {
                    Field sizeField = objectType.getDeclaredField(sizedBy.value());
                    sizeField.setAccessible(true);
                    int size = (Integer)sizeField.get(o);
                    fieldObject = Array.newInstance(fieldType.getComponentType(), size);
                }
                this.decodeArray(fieldObject, fieldType.getComponentType(), field.getAnnotation(DecodeUnsigned.class), input);
            }
            field.set(o, fieldObject);
        }
    }

    private Object decodePrimitive(DataInput input, Class<?> fieldType, DecodeUnsigned annotation) {
        if (annotation != null) {
            return UnsignedDecoders.get((Object)annotation.value()).apply(input);
        }
        return PrimitiveDecoders.get(fieldType).apply(input);
    }
}

