/*
 * Decompiled with CFR 0.152.
 */
package com.github.memorylorry.type.common;

import com.github.memorylorry.type.Operation;
import java.util.ArrayList;
import java.util.List;

public class CommonList<T>
extends Operation {
    protected List<T> columns = new ArrayList<T>();

    public void addColumn(T column) {
        this.columns.add(column);
    }

    public CommonList<T> addColumnList(CommonList<T> commonList) {
        CommonList<T> res = this.copy();
        List<T> list = commonList.getColumns();
        for (T o : list) {
            res.addColumn(o);
        }
        return res;
    }

    public CommonList<T> copy() {
        CommonList<T> res = new CommonList<T>();
        for (T column : this.columns) {
            res.addColumn(column);
        }
        return res;
    }

    @Override
    public String toSQL() {
        return this.toSQLDivdByValue(",");
    }

    @Override
    public String toSQLWithAS() {
        return this.toSQLWithASDivdByValue(",");
    }

    public String toSQLDivdByValue(String value) {
        value = value.toUpperCase();
        String res = "";
        for (T column : this.columns) {
            Operation op = (Operation)column;
            res = res + value + op.toSQL();
        }
        if (res.length() > 0) {
            int len = value.length();
            res = res.substring(len, res.length());
        }
        return res;
    }

    public String toSQLWithASDivdByValue(String value) {
        value = value.toUpperCase();
        String res = "";
        for (T column : this.columns) {
            Operation op = (Operation)column;
            res = res + value + op.toSQLWithAS();
        }
        if (res.length() > 0) {
            int len = value.length();
            res = res.substring(len, res.length());
        }
        return res;
    }

    public void setColumns(List<T> columns) {
        this.columns = columns;
    }

    public List<T> getColumns() {
        return this.columns;
    }
}

