/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util.datastructure;

import de.mrapp.util.Condition;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListenerList<T>
implements Iterable<T> {
    private final Object lock = new Object();
    private final CompareMethod compareMethod;
    private List<T> listeners;

    private boolean contains(@NotNull Iterable<? extends T> iterable, @NotNull T listener) {
        for (T t : iterable) {
            if (!this.equals(t, listener)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(@Nullable T listener1, @Nullable T listener2) {
        if (listener1 == null) {
            return listener2 == null;
        }
        return listener2 != null && (this.compareMethod == CompareMethod.EQUALITY ? listener1.equals(listener2) : listener1 == listener2);
    }

    public ListenerList() {
        this(CompareMethod.EQUALITY);
    }

    public ListenerList(@NotNull CompareMethod compareMethod) {
        Condition.ensureNotNull((Object)compareMethod, "The compare method may not be null");
        this.compareMethod = compareMethod;
        this.clear();
    }

    @NotNull
    public final CompareMethod getCompareMethod() {
        return this.compareMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(@NotNull T listener) {
        Condition.ensureNotNull(listener, "The listener may not be null");
        Object object = this.lock;
        synchronized (object) {
            if (!this.contains(this.listeners, listener)) {
                LinkedList<T> newList = new LinkedList<T>(this.listeners);
                newList.add(listener);
                this.listeners = newList;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAll(@NotNull Iterable<? extends T> iterable) {
        Condition.ensureNotNull(iterable, "The iterable may not be null");
        Object object = this.lock;
        synchronized (object) {
            LinkedList<T> newList = null;
            for (T listener : iterable) {
                Condition.ensureNotNull(listener, "The listener may not be null");
                if (!(newList == null ? !this.contains(this.listeners, listener) : !this.contains(newList, listener))) continue;
                if (newList == null) {
                    newList = new LinkedList<T>(this.listeners);
                }
                newList.add(listener);
            }
            if (newList != null) {
                this.listeners = newList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull T listener) {
        Condition.ensureNotNull(listener, "The listener may not be null");
        Object object = this.lock;
        synchronized (object) {
            if (this.contains(this.listeners, listener)) {
                LinkedList<T> newList = new LinkedList<T>();
                this.listeners.stream().filter(x -> !this.equals(x, listener)).forEach(newList::add);
                this.listeners = newList;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAll(@NotNull Iterable<? extends T> iterable) {
        Condition.ensureNotNull(iterable, "The iterable may not be null");
        Object object = this.lock;
        synchronized (object) {
            LinkedList<T> newList = null;
            for (T listener : this.listeners) {
                if (this.contains(iterable, listener)) continue;
                if (newList == null) {
                    newList = new LinkedList<T>();
                }
                newList.add(listener);
            }
            if (newList != null) {
                this.listeners = newList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.listeners = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<T> getAll() {
        Object object = this.lock;
        synchronized (object) {
            return this.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(new LinkedList<T>(this.listeners));
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.listeners.iterator();
    }

    public static enum CompareMethod {
        EQUALITY,
        IDENTITY;

    }
}

