/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import tss.Helpers;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.Tpm;
import tss.TpmCallbackInterface;
import tss.TpmDeviceBase;
import tss.TpmException;
import tss.TpmHelpers;
import tss.TpmStructure;
import tss.tpm.TPMA_SESSION;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RC;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_ST;

public abstract class TpmBase
implements Closeable {
    public TPM_HANDLE _OwnerHandle = TPM_HANDLE.from(TPM_RH.OWNER);
    public TPM_HANDLE _EndorsementHandle = TPM_HANDLE.from(TPM_RH.ENDORSEMENT);
    public TPM_HANDLE _PlatformHandle = TPM_HANDLE.from(TPM_RH.PLATFORM);
    public TPM_HANDLE _LockoutHandle = TPM_HANDLE.from(TPM_RH.LOCKOUT);
    TpmDeviceBase device;
    TpmCallbackInterface callbackObject;
    TPM_RC lastResponseCode;
    boolean AllowErrors;
    TPM_RC[] ExpectedResponses;
    TPM_HANDLE[] ExplicitSessionHandles;

    public void _setDevice(TpmDeviceBase theDevice) {
        this.device = theDevice;
        this.lastResponseCode = TPM_RC.SUCCESS;
    }

    public TpmDeviceBase _getDevice() {
        return this.device;
    }

    public Tpm _allowErrors() {
        this.AllowErrors = true;
        return (Tpm)this;
    }

    public TPM_RC[] _GetExpectedResponses() {
        return this.ExpectedResponses;
    }

    public Tpm _expectError(TPM_RC expectedResponse) {
        return this._expectResponses(expectedResponse);
    }

    public Tpm _expectResponses(TPM_RC ... expectedResponses) {
        this.ExpectedResponses = null;
        if (expectedResponses.length == 0 || expectedResponses.length == 1 && Helpers.isOneOf(expectedResponses[0], TPM_RC.SUCCESS, null)) {
            return (Tpm)this;
        }
        this.ExpectedResponses = new TPM_RC[0];
        return this._expectMoreResponses(expectedResponses);
    }

    public Tpm _expectMoreResponses(TPM_RC ... expectedResponses) {
        int i;
        if (this.ExpectedResponses == null) {
            this.ExpectedResponses = new TPM_RC[]{TPM_RC.SUCCESS};
        }
        TPM_RC[] old = this.ExpectedResponses;
        this.ExpectedResponses = new TPM_RC[expectedResponses.length + old.length];
        for (i = 0; i < old.length; ++i) {
            this.ExpectedResponses[i] = old[i];
        }
        for (i = 0; i < expectedResponses.length; ++i) {
            TPM_RC rc = expectedResponses[i];
            int curPos = old.length + i;
            if (rc == TPM_RC.SUCCESS && curPos != 0) {
                if (this.ExpectedResponses[0] == TPM_RC.SUCCESS) continue;
                rc = this.ExpectedResponses[0];
                this.ExpectedResponses[0] = TPM_RC.SUCCESS;
            }
            this.ExpectedResponses[curPos] = rc;
        }
        return (Tpm)this;
    }

    private boolean _isSuccessExpected() {
        return this.ExpectedResponses == null || this.ExpectedResponses[0] == TPM_RC.SUCCESS;
    }

    public Boolean _lastCommandSucceeded() {
        return this.lastResponseCode == TPM_RC.SUCCESS;
    }

    public TPM_RC _getLastResponseCode() {
        return this.lastResponseCode;
    }

    public Tpm _withSession(TPM_HANDLE h) {
        this.ExplicitSessionHandles = new TPM_HANDLE[]{h};
        return (Tpm)this;
    }

    public Tpm _withSessions(TPM_HANDLE ... hh) {
        this.ExplicitSessionHandles = hh;
        return (Tpm)this;
    }

    public TPM_RC getLastResponseCode() {
        return this.lastResponseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void DispatchCommand(TPM_CC command, TPM_HANDLE[] inHandles, int authHandleCount, int outHandleCount, TpmStructure inParms, TpmStructure outParms) {
        try {
            int numExplicitSessions = this.ExplicitSessionHandles == null ? 0 : this.ExplicitSessionHandles.length;
            boolean haveSessions = authHandleCount != 0 || numExplicitSessions != 0;
            OutByteBuf outBuf = new OutByteBuf();
            int tag = haveSessions ? TPM_ST.SESSIONS.toInt() : TPM_ST.NO_SESSIONS.toInt();
            outBuf.writeInt(tag, 2);
            outBuf.writeInt(0, 4);
            outBuf.writeInt(command.toInt(), 4);
            for (int j = 0; j < inHandles.length; ++j) {
                outBuf.writeInt(inHandles[j].handle, 4);
            }
            OutByteBuf sessionBuf = new OutByteBuf();
            if (haveSessions) {
                if (numExplicitSessions == 0) {
                    TPM_RH pwapHandle = TPM_RH.RS_PW;
                    TPMA_SESSION sessionAttributes = TPMA_SESSION.continueSession;
                    for (int j = 0; j < authHandleCount; ++j) {
                        boolean authMissing = inHandles[j].AuthValue == null;
                        int authValLen = authMissing ? 0 : inHandles[j].AuthValue.length;
                        byte[] authVal = authMissing ? new byte[]{} : inHandles[j].AuthValue;
                        sessionBuf.write(pwapHandle);
                        sessionBuf.writeInt(0, 2);
                        sessionBuf.write(sessionAttributes);
                        sessionBuf.writeInt(authValLen, 2);
                        sessionBuf.write(authVal);
                    }
                } else {
                    if (this.ExplicitSessionHandles.length < authHandleCount) {
                        this.ExplicitSessionHandles = null;
                        throw new TpmException("Needed at least " + String.valueOf(authHandleCount) + " session handles, but only " + String.valueOf(this.ExplicitSessionHandles.length) + " were provided");
                    }
                    block10: for (int j = 0; j < this.ExplicitSessionHandles.length; ++j) {
                        TPM_HANDLE h = this.ExplicitSessionHandles[j];
                        TPMA_SESSION sessionAttributes = TPMA_SESSION.continueSession;
                        TPM_RH pwapHandle = TPM_RH.RS_PW;
                        if (h.handle == TPM_RH.RS_PW.toInt()) {
                            boolean authMissing = inHandles[j].AuthValue == null;
                            int authValLen = authMissing ? 0 : inHandles[j].AuthValue.length;
                            byte[] authVal = authMissing ? new byte[]{} : inHandles[j].AuthValue;
                            sessionBuf.write(pwapHandle);
                            sessionBuf.writeInt(0, 2);
                            sessionBuf.write(sessionAttributes);
                            sessionBuf.writeInt(authValLen, 2);
                            sessionBuf.write(authVal);
                            continue;
                        }
                        switch (h.getType().asEnum()) {
                            case POLICY_SESSION: {
                                sessionBuf.write(h.handle);
                                sessionBuf.writeInt(0, 2);
                                sessionBuf.write(sessionAttributes);
                                sessionBuf.writeInt(0, 2);
                                continue block10;
                            }
                            default: {
                                throw new RuntimeException("Unsupported handle type in session");
                            }
                        }
                    }
                    this.ExplicitSessionHandles = null;
                }
                outBuf.writeInt(sessionBuf.size(), 4);
                outBuf.write(sessionBuf.getBuf());
            }
            OutByteBuf parmsBuf = new OutByteBuf();
            inParms.toTpm(parmsBuf);
            outBuf.writeArrayFragment(parmsBuf.getBuf(), inHandles.length * 4, parmsBuf.size());
            OutByteBuf finalBuf = new OutByteBuf();
            finalBuf.writeArrayFragment(outBuf.getBuf(), 0, 2);
            finalBuf.writeInt(outBuf.size(), 4);
            finalBuf.writeArrayFragment(outBuf.getBuf(), 6, outBuf.size());
            byte[] cBuf = finalBuf.getBuf();
            byte[] rBuf = null;
            int nvRateRecoveryCount = 4;
            InByteBuf respBuf = null;
            TPM_ST respTag = TPM_ST.NULL;
            int rawResponseCode = 0;
            do {
                this.device.dispatchCommand(cBuf);
                rBuf = this.device.getResponse();
                respBuf = new InByteBuf(rBuf);
                int respTagInt = respBuf.readInt(2);
                respTag = TPM_ST.fromInt(respTagInt);
                respBuf.readInt(4);
                rawResponseCode = respBuf.readInt(4);
                this.lastResponseCode = TpmHelpers.fromRawResponse(rawResponseCode);
                if (this.callbackObject == null) continue;
                this.callbackObject.commandCompleteCallback(command, this.lastResponseCode, cBuf, rBuf);
            } while (this.lastResponseCode == TPM_RC.RETRY);
            if (this.lastResponseCode != TPM_RC.NV_RATE || ++nvRateRecoveryCount > 4) {
                // empty if block
            }
            if (this.lastResponseCode != TPM_RC.SUCCESS) {
                if (this.AllowErrors) {
                    return;
                }
                if (Helpers.isOneOf(this.lastResponseCode, this.ExpectedResponses)) {
                    return;
                }
                if (this._isSuccessExpected()) {
                    System.out.println("TPM ERROR: " + this.lastResponseCode);
                    throw new TpmException(this.lastResponseCode, rawResponseCode);
                }
                String expected = this.ExpectedResponses.length > 1 ? Arrays.toString(this.ExpectedResponses) : this.ExpectedResponses[0].toString();
                throw new TpmException("TPM returned unexpected error " + this.lastResponseCode + " instead of " + expected, this.lastResponseCode);
            }
            if (this.ExpectedResponses != null) {
                String expected = this.ExpectedResponses.length > 1 ? "s " + Arrays.toString(this.ExpectedResponses) + " were" : " " + this.ExpectedResponses.toString() + " was";
                throw new TpmException("Error" + expected + " expected, but the TPM command " + command + " succeeded");
            }
            if (respTag.toInt() != tag) {
                throw new TpmException("Unexpected response tag");
            }
            OutByteBuf respParmBuf = new OutByteBuf();
            TPM_HANDLE[] outHandles = new TPM_HANDLE[outHandleCount];
            for (int j = 0; j < outHandleCount; ++j) {
                outHandles[j] = new TPM_HANDLE();
                outHandles[j].initFromTpm(respBuf);
                outHandles[j].toTpm(respParmBuf);
            }
            byte[] responseWithoutHandles = null;
            if (haveSessions) {
                int restOfParmSize = respBuf.readInt(4);
                responseWithoutHandles = respBuf.readByteArray(restOfParmSize);
                respParmBuf.writeArray(responseWithoutHandles);
            } else {
                responseWithoutHandles = respBuf.getRemaining();
                respParmBuf.writeArray(responseWithoutHandles);
            }
            if (haveSessions) {
                this.processResponseSessions(respBuf);
            }
            if (outParms != null) {
                InByteBuf responseData = new InByteBuf(respParmBuf.getBuf());
                outParms.initFromTpm(responseData);
            }
        }
        finally {
            this.AllowErrors = false;
            this.ExpectedResponses = null;
        }
    }

    void processResponseSessions(InByteBuf b) {
    }

    public void _setCallback(TpmCallbackInterface callback) {
        this.callbackObject = callback;
    }

    @Override
    public void close() throws IOException {
        this.device.close();
        this.device = null;
    }
}

