/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;

public class DuplicateResponse
extends TpmStructure {
    public byte[] encryptionKeyOut;
    public TPM2B_PRIVATE duplicate;
    public byte[] outSymSeed;

    public DuplicateResponse(byte[] _encryptionKeyOut, TPM2B_PRIVATE _duplicate, byte[] _outSymSeed) {
        this.encryptionKeyOut = _encryptionKeyOut;
        this.duplicate = _duplicate;
        this.outSymSeed = _outSymSeed;
    }

    public DuplicateResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.encryptionKeyOut != null ? this.encryptionKeyOut.length : 0, 2);
        buf.write(this.encryptionKeyOut);
        this.duplicate.toTpm(buf);
        buf.writeInt(this.outSymSeed != null ? this.outSymSeed.length : 0, 2);
        buf.write(this.outSymSeed);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _encryptionKeyOutSize = buf.readInt(2);
        this.encryptionKeyOut = new byte[_encryptionKeyOutSize];
        buf.readArrayOfInts(this.encryptionKeyOut, 1, _encryptionKeyOutSize);
        this.duplicate = TPM2B_PRIVATE.fromTpm(buf);
        int _outSymSeedSize = buf.readInt(2);
        this.outSymSeed = new byte[_outSymSeedSize];
        buf.readArrayOfInts(this.outSymSeed, 1, _outSymSeedSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static DuplicateResponse fromTpm(byte[] x) {
        DuplicateResponse ret = new DuplicateResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static DuplicateResponse fromTpm(InByteBuf buf) {
        DuplicateResponse ret = new DuplicateResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Duplicate_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "encryptionKeyOut", this.encryptionKeyOut);
        _p.add(d, "TPM2B_PRIVATE", "duplicate", this.duplicate);
        _p.add(d, "byte", "outSymSeed", this.outSymSeed);
    }
}

