/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class LoadResponse
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] name;

    public LoadResponse(TPM_HANDLE _handle, byte[] _name) {
        this.handle = _handle;
        this.name = _name;
    }

    public LoadResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.name != null ? this.name.length : 0, 2);
        buf.write(this.name);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _nameSize = buf.readInt(2);
        this.name = new byte[_nameSize];
        buf.readArrayOfInts(this.name, 1, _nameSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static LoadResponse fromTpm(byte[] x) {
        LoadResponse ret = new LoadResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static LoadResponse fromTpm(InByteBuf buf) {
        LoadResponse ret = new LoadResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Load_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte", "name", this.name);
    }
}

