/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ATTEST;

public class TPM2B_ATTEST
extends TpmStructure {
    public TPMS_ATTEST attestationData;

    public TPM2B_ATTEST(TPMS_ATTEST _attestationData) {
        this.attestationData = _attestationData;
    }

    public TPM2B_ATTEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.attestationData != null ? this.attestationData.toTpm().length : 0, 2);
        this.attestationData.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _size = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _size));
        this.attestationData = TPMS_ATTEST.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2B_ATTEST fromTpm(byte[] x) {
        TPM2B_ATTEST ret = new TPM2B_ATTEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2B_ATTEST fromTpm(InByteBuf buf) {
        TPM2B_ATTEST ret = new TPM2B_ATTEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2B_ATTEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_ATTEST", "attestationData", this.attestationData);
    }
}

