/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_PCR_SetAuthPolicy_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public byte[] authPolicy;
    public TPM_ALG_ID hashAlg;
    public TPM_HANDLE pcrNum;

    public TPM2_PCR_SetAuthPolicy_REQUEST(TPM_HANDLE _authHandle, byte[] _authPolicy, TPM_ALG_ID _hashAlg, TPM_HANDLE _pcrNum) {
        this.authHandle = _authHandle;
        this.authPolicy = _authPolicy;
        this.hashAlg = _hashAlg;
        this.pcrNum = _pcrNum;
    }

    public TPM2_PCR_SetAuthPolicy_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        buf.writeInt(this.authPolicy != null ? this.authPolicy.length : 0, 2);
        buf.write(this.authPolicy);
        this.hashAlg.toTpm(buf);
        this.pcrNum.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        int _authPolicySize = buf.readInt(2);
        this.authPolicy = new byte[_authPolicySize];
        buf.readArrayOfInts(this.authPolicy, 1, _authPolicySize);
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
        this.pcrNum = TPM_HANDLE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PCR_SetAuthPolicy_REQUEST fromTpm(byte[] x) {
        TPM2_PCR_SetAuthPolicy_REQUEST ret = new TPM2_PCR_SetAuthPolicy_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PCR_SetAuthPolicy_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PCR_SetAuthPolicy_REQUEST ret = new TPM2_PCR_SetAuthPolicy_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_SetAuthPolicy_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "byte", "authPolicy", this.authPolicy);
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
        _p.add(d, "TPM_HANDLE", "pcrNum", this.pcrNum);
    }
}

