/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_HANDLE;

public class TPM2_SetCommandCodeAuditStatus_REQUEST
extends TpmStructure {
    public TPM_HANDLE auth;
    public TPM_ALG_ID auditAlg;
    public TPM_CC[] setList;
    public TPM_CC[] clearList;

    public TPM2_SetCommandCodeAuditStatus_REQUEST(TPM_HANDLE _auth, TPM_ALG_ID _auditAlg, TPM_CC[] _setList, TPM_CC[] _clearList) {
        this.auth = _auth;
        this.auditAlg = _auditAlg;
        this.setList = _setList;
        this.clearList = _clearList;
    }

    public TPM2_SetCommandCodeAuditStatus_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.auth.toTpm(buf);
        this.auditAlg.toTpm(buf);
        buf.writeInt(this.setList != null ? this.setList.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.setList);
        buf.writeInt(this.clearList != null ? this.clearList.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.clearList);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.auth = TPM_HANDLE.fromTpm(buf);
        this.auditAlg = TPM_ALG_ID.fromTpm(buf);
        int _setListCount = buf.readInt(4);
        this.setList = new TPM_CC[_setListCount];
        for (int j = 0; j < _setListCount; ++j) {
            this.setList[j] = TPM_CC.fromTpm(buf);
        }
        int _clearListCount = buf.readInt(4);
        this.clearList = new TPM_CC[_clearListCount];
        for (int j = 0; j < _clearListCount; ++j) {
            this.clearList[j] = TPM_CC.fromTpm(buf);
        }
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_SetCommandCodeAuditStatus_REQUEST fromTpm(byte[] x) {
        TPM2_SetCommandCodeAuditStatus_REQUEST ret = new TPM2_SetCommandCodeAuditStatus_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_SetCommandCodeAuditStatus_REQUEST fromTpm(InByteBuf buf) {
        TPM2_SetCommandCodeAuditStatus_REQUEST ret = new TPM2_SetCommandCodeAuditStatus_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_SetCommandCodeAuditStatus_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "auth", this.auth);
        _p.add(d, "TPM_ALG_ID", "auditAlg", this.auditAlg);
        _p.add(d, "TPM_CC", "setList", this.setList);
        _p.add(d, "TPM_CC", "clearList", this.clearList);
    }
}

