/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SYM_DEF;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_SE;

public class TPM2_StartAuthSession_REQUEST
extends TpmStructure {
    public TPM_HANDLE tpmKey;
    public TPM_HANDLE bind;
    public byte[] nonceCaller;
    public byte[] encryptedSalt;
    public TPM_SE sessionType;
    public TPMT_SYM_DEF symmetric;
    public TPM_ALG_ID authHash;

    public TPM2_StartAuthSession_REQUEST(TPM_HANDLE _tpmKey, TPM_HANDLE _bind, byte[] _nonceCaller, byte[] _encryptedSalt, TPM_SE _sessionType, TPMT_SYM_DEF _symmetric, TPM_ALG_ID _authHash) {
        this.tpmKey = _tpmKey;
        this.bind = _bind;
        this.nonceCaller = _nonceCaller;
        this.encryptedSalt = _encryptedSalt;
        this.sessionType = _sessionType;
        this.symmetric = _symmetric;
        this.authHash = _authHash;
    }

    public TPM2_StartAuthSession_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.tpmKey.toTpm(buf);
        this.bind.toTpm(buf);
        buf.writeInt(this.nonceCaller != null ? this.nonceCaller.length : 0, 2);
        buf.write(this.nonceCaller);
        buf.writeInt(this.encryptedSalt != null ? this.encryptedSalt.length : 0, 2);
        buf.write(this.encryptedSalt);
        this.sessionType.toTpm(buf);
        this.symmetric.toTpm(buf);
        this.authHash.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.tpmKey = TPM_HANDLE.fromTpm(buf);
        this.bind = TPM_HANDLE.fromTpm(buf);
        int _nonceCallerSize = buf.readInt(2);
        this.nonceCaller = new byte[_nonceCallerSize];
        buf.readArrayOfInts(this.nonceCaller, 1, _nonceCallerSize);
        int _encryptedSaltSize = buf.readInt(2);
        this.encryptedSalt = new byte[_encryptedSaltSize];
        buf.readArrayOfInts(this.encryptedSalt, 1, _encryptedSaltSize);
        this.sessionType = TPM_SE.fromTpm(buf);
        this.symmetric = TPMT_SYM_DEF.fromTpm(buf);
        this.authHash = TPM_ALG_ID.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_StartAuthSession_REQUEST fromTpm(byte[] x) {
        TPM2_StartAuthSession_REQUEST ret = new TPM2_StartAuthSession_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_StartAuthSession_REQUEST fromTpm(InByteBuf buf) {
        TPM2_StartAuthSession_REQUEST ret = new TPM2_StartAuthSession_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_StartAuthSession_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "tpmKey", this.tpmKey);
        _p.add(d, "TPM_HANDLE", "bind", this.bind);
        _p.add(d, "byte", "nonceCaller", this.nonceCaller);
        _p.add(d, "byte", "encryptedSalt", this.encryptedSalt);
        _p.add(d, "TPM_SE", "sessionType", this.sessionType);
        _p.add(d, "TPMT_SYM_DEF", "symmetric", this.symmetric);
        _p.add(d, "TPM_ALG_ID", "authHash", this.authHash);
    }
}

