/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_CC;
import tss.tpm.TPMU_CAPABILITIES;

public class TPML_CCA
extends TpmStructure
implements TPMU_CAPABILITIES {
    public TPMA_CC[] commandAttributes;

    public TPML_CCA(TPMA_CC[] _commandAttributes) {
        this.commandAttributes = _commandAttributes;
    }

    public TPML_CCA() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.commandAttributes != null ? this.commandAttributes.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.commandAttributes);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _count = buf.readInt(4);
        this.commandAttributes = new TPMA_CC[_count];
        for (int j = 0; j < _count; ++j) {
            this.commandAttributes[j] = new TPMA_CC(0);
            this.commandAttributes[j].initFromTpm(buf);
        }
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPML_CCA fromTpm(byte[] x) {
        TPML_CCA ret = new TPML_CCA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPML_CCA fromTpm(InByteBuf buf) {
        TPML_CCA ret = new TPML_CCA();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPML_CCA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMA_CC", "commandAttributes", this.commandAttributes);
    }
}

