/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class TPMS_SIGNATURE_RSA
extends TpmStructure
implements TPMU_SIGNATURE {
    public TPM_ALG_ID hash;
    public byte[] sig;

    public TPMS_SIGNATURE_RSA(TPM_ALG_ID _hash, byte[] _sig) {
        this.hash = _hash;
        this.sig = _sig;
    }

    public TPMS_SIGNATURE_RSA() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.hash.toTpm(buf);
        buf.writeInt(this.sig != null ? this.sig.length : 0, 2);
        buf.write(this.sig);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.hash = TPM_ALG_ID.fromTpm(buf);
        int _sigSize = buf.readInt(2);
        this.sig = new byte[_sigSize];
        buf.readArrayOfInts(this.sig, 1, _sigSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_SIGNATURE_RSA fromTpm(byte[] x) {
        TPMS_SIGNATURE_RSA ret = new TPMS_SIGNATURE_RSA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_SIGNATURE_RSA fromTpm(InByteBuf buf) {
        TPMS_SIGNATURE_RSA ret = new TPMS_SIGNATURE_RSA();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_SIGNATURE_RSA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hash", this.hash);
        _p.add(d, "byte", "sig", this.sig);
    }
}

