/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.Crypto;
import tss.Helpers;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.PCR_ReadResponse;
import tss.tpm.QuoteResponse;
import tss.tpm.TPM2B_DIGEST_Keyedhash;
import tss.tpm.TPM2B_DIGEST_Symcipher;
import tss.tpm.TPM2B_PUBLIC_KEY_RSA;
import tss.tpm.TPMA_OBJECT;
import tss.tpm.TPMS_ASYM_PARMS;
import tss.tpm.TPMS_DERIVE;
import tss.tpm.TPMS_ECC_PARMS;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPMS_KEYEDHASH_PARMS;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SYMCIPHER_PARMS;
import tss.tpm.TPMU_PUBLIC_ID;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class TPMT_PUBLIC
extends TpmStructure {
    public TPM_ALG_ID nameAlg;
    public TPMA_OBJECT objectAttributes;
    public byte[] authPolicy;
    public TPMU_PUBLIC_PARMS parameters;
    public TPMU_PUBLIC_ID unique;

    public TPMT_PUBLIC(TPM_ALG_ID _nameAlg, TPMA_OBJECT _objectAttributes, byte[] _authPolicy, TPMU_PUBLIC_PARMS _parameters, TPMU_PUBLIC_ID _unique) {
        this.nameAlg = _nameAlg;
        this.objectAttributes = _objectAttributes;
        this.authPolicy = _authPolicy;
        this.parameters = _parameters;
        this.unique = _unique;
    }

    public TPMT_PUBLIC() {
    }

    public int GetUnionSelector_parameters() {
        if (this.parameters instanceof TPMS_KEYEDHASH_PARMS) {
            return 8;
        }
        if (this.parameters instanceof TPMS_SYMCIPHER_PARMS) {
            return 37;
        }
        if (this.parameters instanceof TPMS_RSA_PARMS) {
            return 1;
        }
        if (this.parameters instanceof TPMS_ECC_PARMS) {
            return 35;
        }
        if (this.parameters instanceof TPMS_ASYM_PARMS) {
            return Short.MAX_VALUE;
        }
        throw new RuntimeException("Unrecognized type");
    }

    public int GetUnionSelector_unique() {
        if (this.unique instanceof TPM2B_DIGEST_Keyedhash) {
            return 8;
        }
        if (this.unique instanceof TPM2B_DIGEST_Symcipher) {
            return 37;
        }
        if (this.unique instanceof TPM2B_PUBLIC_KEY_RSA) {
            return 1;
        }
        if (this.unique instanceof TPMS_ECC_POINT) {
            return 35;
        }
        if (this.unique instanceof TPMS_DERIVE) {
            return Short.MAX_VALUE;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_parameters(), 2);
        this.nameAlg.toTpm(buf);
        this.objectAttributes.toTpm(buf);
        buf.writeInt(this.authPolicy != null ? this.authPolicy.length : 0, 2);
        buf.write(this.authPolicy);
        this.parameters.toTpm(buf);
        this.unique.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _type = buf.readInt(2);
        this.nameAlg = TPM_ALG_ID.fromTpm(buf);
        int _objectAttributes = buf.readInt(4);
        this.objectAttributes = TPMA_OBJECT.fromInt(_objectAttributes);
        int _authPolicySize = buf.readInt(2);
        this.authPolicy = new byte[_authPolicySize];
        buf.readArrayOfInts(this.authPolicy, 1, _authPolicySize);
        this.parameters = null;
        if (_type == TPM_ALG_ID.KEYEDHASH.toInt()) {
            this.parameters = new TPMS_KEYEDHASH_PARMS();
        } else if (_type == TPM_ALG_ID.SYMCIPHER.toInt()) {
            this.parameters = new TPMS_SYMCIPHER_PARMS();
        } else if (_type == TPM_ALG_ID.RSA.toInt()) {
            this.parameters = new TPMS_RSA_PARMS();
        } else if (_type == TPM_ALG_ID.ECC.toInt()) {
            this.parameters = new TPMS_ECC_PARMS();
        } else if (_type == TPM_ALG_ID.ANY.toInt()) {
            this.parameters = new TPMS_ASYM_PARMS();
        }
        if (this.parameters == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.parameters.initFromTpm(buf);
        this.unique = null;
        if (_type == TPM_ALG_ID.KEYEDHASH.toInt()) {
            this.unique = new TPM2B_DIGEST_Keyedhash();
        } else if (_type == TPM_ALG_ID.SYMCIPHER.toInt()) {
            this.unique = new TPM2B_DIGEST_Symcipher();
        } else if (_type == TPM_ALG_ID.RSA.toInt()) {
            this.unique = new TPM2B_PUBLIC_KEY_RSA();
        } else if (_type == TPM_ALG_ID.ECC.toInt()) {
            this.unique = new TPMS_ECC_POINT();
        } else if (_type == TPM_ALG_ID.ANY.toInt()) {
            this.unique = new TPMS_DERIVE();
        }
        if (this.unique == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.unique.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_PUBLIC fromTpm(byte[] x) {
        TPMT_PUBLIC ret = new TPMT_PUBLIC();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_PUBLIC fromTpm(InByteBuf buf) {
        TPMT_PUBLIC ret = new TPMT_PUBLIC();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_PUBLIC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "nameAlg", this.nameAlg);
        _p.add(d, "TPMA_OBJECT", "objectAttributes", this.objectAttributes);
        _p.add(d, "byte", "authPolicy", this.authPolicy);
        _p.add(d, "TPMU_PUBLIC_PARMS", "parameters", this.parameters);
        _p.add(d, "TPMU_PUBLIC_ID", "unique", this.unique);
    }

    public boolean validateSignature(byte[] _dataThatWasSigned, TPMU_SIGNATURE _signature) {
        return Crypto.validateSignature(this, _dataThatWasSigned, _signature);
    }

    public byte[] encrypt(byte[] inData, String label) {
        return Crypto.asymEncrypt(this, inData, label);
    }

    public byte[] getName() {
        byte[] pub = this.toTpm();
        byte[] pubHash = Crypto.hash(this.nameAlg, pub);
        byte[] theHashAlg = Helpers.hostToNet((short)this.nameAlg.toInt());
        return Helpers.concatenate(theHashAlg, pubHash);
    }

    public boolean validateQuote(PCR_ReadResponse expectedPcrs, byte[] nonce, QuoteResponse quote) {
        return Crypto.validateQuote(this, expectedPcrs, nonce, quote);
    }
}

