/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class HMACResponse
extends TpmStructure {
    public byte[] outHMAC;

    public HMACResponse(byte[] _outHMAC) {
        this.outHMAC = _outHMAC;
    }

    public HMACResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.outHMAC != null ? this.outHMAC.length : 0, 2);
        if (this.outHMAC != null) {
            buf.write(this.outHMAC);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _outHMACSize = buf.readInt(2);
        this.outHMAC = new byte[_outHMACSize];
        buf.readArrayOfInts(this.outHMAC, 1, _outHMACSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static HMACResponse fromTpm(byte[] x) {
        HMACResponse ret = new HMACResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static HMACResponse fromTpm(InByteBuf buf) {
        HMACResponse ret = new HMACResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_HMAC_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "outHMAC", this.outHMAC);
    }
}

