/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_MakeCredential_REQUEST
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] credential;
    public byte[] objectName;

    public TPM2_MakeCredential_REQUEST(TPM_HANDLE _handle, byte[] _credential, byte[] _objectName) {
        this.handle = _handle;
        this.credential = _credential;
        this.objectName = _objectName;
    }

    public TPM2_MakeCredential_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.credential != null ? this.credential.length : 0, 2);
        if (this.credential != null) {
            buf.write(this.credential);
        }
        buf.writeInt(this.objectName != null ? this.objectName.length : 0, 2);
        if (this.objectName != null) {
            buf.write(this.objectName);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _credentialSize = buf.readInt(2);
        this.credential = new byte[_credentialSize];
        buf.readArrayOfInts(this.credential, 1, _credentialSize);
        int _objectNameSize = buf.readInt(2);
        this.objectName = new byte[_objectNameSize];
        buf.readArrayOfInts(this.objectName, 1, _objectNameSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_MakeCredential_REQUEST fromTpm(byte[] x) {
        TPM2_MakeCredential_REQUEST ret = new TPM2_MakeCredential_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_MakeCredential_REQUEST fromTpm(InByteBuf buf) {
        TPM2_MakeCredential_REQUEST ret = new TPM2_MakeCredential_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_MakeCredential_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte", "credential", this.credential);
        _p.add(d, "byte", "objectName", this.objectName);
    }
}

