/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_NV_Write_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public TPM_HANDLE nvIndex;
    public byte[] data;
    public short offset;

    public TPM2_NV_Write_REQUEST(TPM_HANDLE _authHandle, TPM_HANDLE _nvIndex, byte[] _data, int _offset) {
        this.authHandle = _authHandle;
        this.nvIndex = _nvIndex;
        this.data = _data;
        this.offset = (short)_offset;
    }

    public TPM2_NV_Write_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        this.nvIndex.toTpm(buf);
        buf.writeInt(this.data != null ? this.data.length : 0, 2);
        if (this.data != null) {
            buf.write(this.data);
        }
        buf.write(this.offset);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        this.nvIndex = TPM_HANDLE.fromTpm(buf);
        int _dataSize = buf.readInt(2);
        this.data = new byte[_dataSize];
        buf.readArrayOfInts(this.data, 1, _dataSize);
        this.offset = (short)buf.readInt(2);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_NV_Write_REQUEST fromTpm(byte[] x) {
        TPM2_NV_Write_REQUEST ret = new TPM2_NV_Write_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_NV_Write_REQUEST fromTpm(InByteBuf buf) {
        TPM2_NV_Write_REQUEST ret = new TPM2_NV_Write_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_Write_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "byte", "data", this.data);
        _p.add(d, "ushort", "offset", this.offset);
    }
}

