/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ASYM_PARMS;
import tss.tpm.TPMS_ECC_PARMS;
import tss.tpm.TPMS_KEYEDHASH_PARMS;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SYMCIPHER_PARMS;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPM_ALG_ID;

public class TPM2_TestParms_REQUEST
extends TpmStructure {
    public TPMU_PUBLIC_PARMS parameters;

    public TPM2_TestParms_REQUEST(TPMU_PUBLIC_PARMS _parameters) {
        this.parameters = _parameters;
    }

    public TPM2_TestParms_REQUEST() {
    }

    public int GetUnionSelector_parameters() {
        if (this.parameters instanceof TPMS_KEYEDHASH_PARMS) {
            return 8;
        }
        if (this.parameters instanceof TPMS_SYMCIPHER_PARMS) {
            return 37;
        }
        if (this.parameters instanceof TPMS_RSA_PARMS) {
            return 1;
        }
        if (this.parameters instanceof TPMS_ECC_PARMS) {
            return 35;
        }
        if (this.parameters instanceof TPMS_ASYM_PARMS) {
            return Short.MAX_VALUE;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_parameters(), 2);
        this.parameters.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _parametersType = buf.readInt(2);
        this.parameters = null;
        if (_parametersType == TPM_ALG_ID.KEYEDHASH.toInt()) {
            this.parameters = new TPMS_KEYEDHASH_PARMS();
        } else if (_parametersType == TPM_ALG_ID.SYMCIPHER.toInt()) {
            this.parameters = new TPMS_SYMCIPHER_PARMS();
        } else if (_parametersType == TPM_ALG_ID.RSA.toInt()) {
            this.parameters = new TPMS_RSA_PARMS();
        } else if (_parametersType == TPM_ALG_ID.ECC.toInt()) {
            this.parameters = new TPMS_ECC_PARMS();
        } else if (_parametersType == TPM_ALG_ID.ANY.toInt()) {
            this.parameters = new TPMS_ASYM_PARMS();
        }
        if (this.parameters == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_parametersType).name());
        }
        this.parameters.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_TestParms_REQUEST fromTpm(byte[] x) {
        TPM2_TestParms_REQUEST ret = new TPM2_TestParms_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_TestParms_REQUEST fromTpm(InByteBuf buf) {
        TPM2_TestParms_REQUEST ret = new TPM2_TestParms_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_TestParms_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_PUBLIC_PARMS", "parameters", this.parameters);
    }
}

