/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CERTIFY_INFO;
import tss.tpm.TPMS_CLOCK_INFO;
import tss.tpm.TPMS_COMMAND_AUDIT_INFO;
import tss.tpm.TPMS_CREATION_INFO;
import tss.tpm.TPMS_NV_CERTIFY_INFO;
import tss.tpm.TPMS_QUOTE_INFO;
import tss.tpm.TPMS_SESSION_AUDIT_INFO;
import tss.tpm.TPMS_TIME_ATTEST_INFO;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_GENERATED;
import tss.tpm.TPM_ST;

public class TPMS_ATTEST
extends TpmStructure {
    public TPM_GENERATED magic;
    public byte[] qualifiedSigner;
    public byte[] extraData;
    public TPMS_CLOCK_INFO clockInfo;
    public long firmwareVersion;
    public TPMU_ATTEST attested;

    public TPMS_ATTEST(TPM_GENERATED _magic, byte[] _qualifiedSigner, byte[] _extraData, TPMS_CLOCK_INFO _clockInfo, long _firmwareVersion, TPMU_ATTEST _attested) {
        this.magic = _magic;
        this.qualifiedSigner = _qualifiedSigner;
        this.extraData = _extraData;
        this.clockInfo = _clockInfo;
        this.firmwareVersion = _firmwareVersion;
        this.attested = _attested;
    }

    public TPMS_ATTEST() {
    }

    public int GetUnionSelector_attested() {
        if (this.attested instanceof TPMS_CERTIFY_INFO) {
            return 32791;
        }
        if (this.attested instanceof TPMS_CREATION_INFO) {
            return 32794;
        }
        if (this.attested instanceof TPMS_QUOTE_INFO) {
            return 32792;
        }
        if (this.attested instanceof TPMS_COMMAND_AUDIT_INFO) {
            return 32789;
        }
        if (this.attested instanceof TPMS_SESSION_AUDIT_INFO) {
            return 32790;
        }
        if (this.attested instanceof TPMS_TIME_ATTEST_INFO) {
            return 32793;
        }
        if (this.attested instanceof TPMS_NV_CERTIFY_INFO) {
            return 32788;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.magic.toTpm(buf);
        buf.writeInt(this.GetUnionSelector_attested(), 2);
        buf.writeInt(this.qualifiedSigner != null ? this.qualifiedSigner.length : 0, 2);
        if (this.qualifiedSigner != null) {
            buf.write(this.qualifiedSigner);
        }
        buf.writeInt(this.extraData != null ? this.extraData.length : 0, 2);
        if (this.extraData != null) {
            buf.write(this.extraData);
        }
        this.clockInfo.toTpm(buf);
        buf.write(this.firmwareVersion);
        this.attested.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.magic = TPM_GENERATED.fromTpm(buf);
        int _type = buf.readInt(2);
        int _qualifiedSignerSize = buf.readInt(2);
        this.qualifiedSigner = new byte[_qualifiedSignerSize];
        buf.readArrayOfInts(this.qualifiedSigner, 1, _qualifiedSignerSize);
        int _extraDataSize = buf.readInt(2);
        this.extraData = new byte[_extraDataSize];
        buf.readArrayOfInts(this.extraData, 1, _extraDataSize);
        this.clockInfo = TPMS_CLOCK_INFO.fromTpm(buf);
        this.firmwareVersion = buf.readLong();
        this.attested = null;
        if (_type == TPM_ST.ATTEST_CERTIFY.toInt()) {
            this.attested = new TPMS_CERTIFY_INFO();
        } else if (_type == TPM_ST.ATTEST_CREATION.toInt()) {
            this.attested = new TPMS_CREATION_INFO();
        } else if (_type == TPM_ST.ATTEST_QUOTE.toInt()) {
            this.attested = new TPMS_QUOTE_INFO();
        } else if (_type == TPM_ST.ATTEST_COMMAND_AUDIT.toInt()) {
            this.attested = new TPMS_COMMAND_AUDIT_INFO();
        } else if (_type == TPM_ST.ATTEST_SESSION_AUDIT.toInt()) {
            this.attested = new TPMS_SESSION_AUDIT_INFO();
        } else if (_type == TPM_ST.ATTEST_TIME.toInt()) {
            this.attested = new TPMS_TIME_ATTEST_INFO();
        } else if (_type == TPM_ST.ATTEST_NV.toInt()) {
            this.attested = new TPMS_NV_CERTIFY_INFO();
        }
        if (this.attested == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_type).name());
        }
        this.attested.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_ATTEST fromTpm(byte[] x) {
        TPMS_ATTEST ret = new TPMS_ATTEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_ATTEST fromTpm(InByteBuf buf) {
        TPMS_ATTEST ret = new TPMS_ATTEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ATTEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_GENERATED", "magic", this.magic);
        _p.add(d, "byte", "qualifiedSigner", this.qualifiedSigner);
        _p.add(d, "byte", "extraData", this.extraData);
        _p.add(d, "TPMS_CLOCK_INFO", "clockInfo", this.clockInfo);
        _p.add(d, "ulong", "firmwareVersion", this.firmwareVersion);
        _p.add(d, "TPMU_ATTEST", "attested", this.attested);
    }
}

