/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CONTEXT_DATA;
import tss.tpm.TPM_HANDLE;

public class TPMS_CONTEXT
extends TpmStructure {
    public long sequence;
    public TPM_HANDLE savedHandle;
    public TPM_HANDLE hierarchy;
    public TPMS_CONTEXT_DATA contextBlob;

    public TPMS_CONTEXT(long _sequence, TPM_HANDLE _savedHandle, TPM_HANDLE _hierarchy, TPMS_CONTEXT_DATA _contextBlob) {
        this.sequence = _sequence;
        this.savedHandle = _savedHandle;
        this.hierarchy = _hierarchy;
        this.contextBlob = _contextBlob;
    }

    public TPMS_CONTEXT() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.sequence);
        this.savedHandle.toTpm(buf);
        this.hierarchy.toTpm(buf);
        buf.writeInt(this.contextBlob != null ? this.contextBlob.toTpm().length : 0, 2);
        if (this.contextBlob != null) {
            this.contextBlob.toTpm(buf);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.sequence = buf.readLong();
        this.savedHandle = TPM_HANDLE.fromTpm(buf);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
        int _contextBlobSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _contextBlobSize));
        this.contextBlob = TPMS_CONTEXT_DATA.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_CONTEXT fromTpm(byte[] x) {
        TPMS_CONTEXT ret = new TPMS_CONTEXT();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_CONTEXT fromTpm(InByteBuf buf) {
        TPMS_CONTEXT ret = new TPMS_CONTEXT();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CONTEXT");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "ulong", "sequence", this.sequence);
        _p.add(d, "TPM_HANDLE", "savedHandle", this.savedHandle);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
        _p.add(d, "TPMS_CONTEXT_DATA", "contextBlob", this.contextBlob);
    }
}

