/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class TPMS_ID_OBJECT
extends TpmStructure {
    public byte[] integrityHMAC;
    public byte[] encIdentity;

    public TPMS_ID_OBJECT(byte[] _integrityHMAC, byte[] _encIdentity) {
        this.integrityHMAC = _integrityHMAC;
        this.encIdentity = _encIdentity;
    }

    public TPMS_ID_OBJECT() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.integrityHMAC != null ? this.integrityHMAC.length : 0, 2);
        if (this.integrityHMAC != null) {
            buf.write(this.integrityHMAC);
        }
        buf.write(this.encIdentity);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _integrityHMACSize = buf.readInt(2);
        this.integrityHMAC = new byte[_integrityHMACSize];
        buf.readArrayOfInts(this.integrityHMAC, 1, _integrityHMACSize);
        InByteBuf.SizedStructInfo si = buf.structSize.peek();
        int _encIdentitySize = si.Size - (buf.curPos() - si.StartPos);
        this.encIdentity = new byte[_encIdentitySize];
        buf.readArrayOfInts(this.encIdentity, 1, _encIdentitySize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_ID_OBJECT fromTpm(byte[] x) {
        TPMS_ID_OBJECT ret = new TPMS_ID_OBJECT();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_ID_OBJECT fromTpm(InByteBuf buf) {
        TPMS_ID_OBJECT ret = new TPMS_ID_OBJECT();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ID_OBJECT");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "integrityHMAC", this.integrityHMAC);
        _p.add(d, "byte", "encIdentity", this.encIdentity);
    }
}

